/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.impl.SyncManager;
import com.waxmonster.audio.impl.SyncSource;

public abstract class AbstractSyncManager
implements SyncManager {
    protected final float rate;
    protected final SyncSource[] src;
    protected final int sn;

    public AbstractSyncManager(float frameRate, int sources) {
        if (frameRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid frame rate: " + frameRate);
        }
        if (sources < 1) {
            throw new IllegalArgumentException("Invalid number of sources: " + sources + " < 1");
        }
        this.rate = frameRate;
        this.src = new SyncSource[sources];
        this.sn = sources;
    }

    @Override
    public synchronized void init(SyncSource[] sources) throws AudioException {
        if (sources.length != this.sn) {
            throw new IllegalArgumentException("Invalid number of sources: " + sources.length + " != " + this.sn);
        }
        for (int i = 0; i < this.sn; ++i) {
            SyncSource source = sources[i];
            if (source == null) {
                throw new AudioException("Missing SyncSource at index: " + i);
            }
            this.src[i] = source;
        }
    }

    @Override
    public final int getSyncSourceCount() {
        return this.sn;
    }

    @Override
    public final synchronized SyncSource getSyncSourceAt(int sourceIndex) {
        return this.src[sourceIndex];
    }

    protected synchronized void resync(SyncSource source) throws AudioException {
        long syncTime = this.src[0].time;
        for (int i = 1; i < this.sn; ++i) {
            SyncSource s = this.src[i];
            if (s.time <= syncTime) continue;
            syncTime = s.time;
        }
        long skipTime = syncTime - source.time;
        if (skipTime > 0L) {
            long skipFrames = (long)((double)skipTime * (double)this.rate / 1.0E9);
            int frames = (int)Math.min(skipFrames, (long)source.todo);
            System.out.println("Resync: syncTime=" + syncTime + ", sourceTime=" + source.time + ", skipTime=" + skipTime + ", skipFrames=" + frames + ", source=" + source);
            if (frames > 0) {
                source.skip(frames);
                source.time = syncTime;
            }
            source.resync = false;
        } else {
            System.out.println("Resync: syncTime=" + syncTime + ", skipTime=" + skipTime + ", source=" + source);
            source.resync = skipTime < 0L;
        }
    }
}

