/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.DoubleArrayRingSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioEngine;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.AudioContextImpl;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.impl.DefaultSyncSource;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.SourceSyncManager;
import com.waxmonster.audio.impl.SyncAudioEngine;
import com.waxmonster.audio.impl.SyncManager;
import com.waxmonster.audio.impl.SyncManagerStrategy;
import com.waxmonster.audio.impl.SyncSource;
import com.waxmonster.audio.impl.SyncSourceProxy;
import com.waxmonster.audio.impl.SyncTarget;
import com.waxmonster.audio.impl.SyncTargetProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSyncManagerStrategy
implements SyncManagerStrategy {
    private static final Logger logger = Logger.getLogger(AbstractSyncManagerStrategy.class.getName());
    protected final boolean debug;
    protected final double minSyncMillis;

    public AbstractSyncManagerStrategy(AudioEngineConfig config) {
        this.debug = config.isDebug();
        this.minSyncMillis = config.getMinSyncMillis();
    }

    @Override
    public boolean resolveFrameRateAndBufferSize(Wrapper wrapper, SyncSourceProxy[] syncSourceProxies, SyncTargetProxy[] syncTargetProxies) throws AudioException {
        float frameRate = -1.0f;
        int bufferFrames = -1;
        for (SyncSourceProxy sourceProxy : syncSourceProxies) {
            int sourceBufferSize;
            WrapperOutputPort sourcePort = sourceProxy.getSourcePort();
            Wrapper sourceWrapper = sourcePort.getWrapper();
            float sourceFrameRate = sourceWrapper.getFrameRate();
            if (sourceFrameRate <= 0.0f || (sourceBufferSize = sourceWrapper.getBufferSize()) <= 0) continue;
            if (frameRate <= 0.0f) {
                frameRate = sourceFrameRate;
                bufferFrames = sourceBufferSize;
                continue;
            }
            if (sourceFrameRate != frameRate) {
                throw new AudioException("Multiple frame rates are not supported (yet): " + sourceFrameRate + " != " + frameRate);
            }
            if (sourceBufferSize <= bufferFrames) continue;
            bufferFrames = sourceBufferSize;
        }
        if (frameRate <= 0.0f || bufferFrames <= 0) {
            return false;
        }
        wrapper.setFrameRate(frameRate);
        wrapper.setBufferSize(bufferFrames);
        return true;
    }

    @Override
    public SyncManager createSyncManager(Wrapper wrapper, SyncSourceProxy[] syncSourceProxies, SyncTargetProxy[] syncTargetProxies, AudioContextImpl context) throws AudioException {
        int minBufferFrames;
        SampleBufferProxy bufferProxy;
        int sourceCount = syncSourceProxies.length;
        if (sourceCount < 1) {
            throw new AudioException("No SyncSource(s) specified!");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating SyncManager: sources=" + sourceCount + ", group=" + wrapper.getGroup() + ", targets=" + syncTargetProxies.length);
        }
        float frameRate = wrapper.getFrameRate();
        int minSyncBufferFrames = wrapper.getBufferSize();
        SampleBuffer[] wrapperInputBuffers = new SampleBuffer[sourceCount];
        for (int i = 0; i < sourceCount; ++i) {
            WrapperInputPort wip;
            SyncSourceProxy syncSourceWrapper = syncSourceProxies[i];
            WrapperOutputPort sourcePort = syncSourceWrapper.getSourcePort();
            Wrapper sourceWrapper = sourcePort.getWrapper();
            float rate = sourceWrapper.getFrameRate();
            if (rate <= 0.0f) {
                throw new AudioException("Invalid frame rate: port=" + sourcePort.getAudioPort() + ", frameRate=" + rate);
            }
            if (rate != frameRate) {
                throw new AudioException("Invalid frame rate: port=" + sourcePort.getAudioPort() + ", frameRate=" + rate + " != " + frameRate);
            }
            int bufSize = sourceWrapper.getBufferSize();
            if (bufSize <= 0) {
                throw new AudioException("Invalid buffer size: port=" + sourcePort.getAudioPort() + ", bufferSize=" + bufSize);
            }
            if (bufSize > minSyncBufferFrames) {
                minSyncBufferFrames = bufSize;
            }
            if ((bufferProxy = (wip = syncSourceWrapper.getInputPort()).getSampleBufferProxy()) == null) {
                throw new AudioException("Input SampleBufferProxy not available: group=" + wrapper.getGroup() + ", port=" + wip.getAudioInputPort());
            }
            SampleBuffer wipBuffer = bufferProxy.getSampleBuffer();
            if (wipBuffer == null) {
                throw new AudioException("Input SampleBuffer not available: group=" + wrapper.getGroup() + ", port=" + wip.getAudioInputPort());
            }
            wrapperInputBuffers[i] = wipBuffer;
        }
        SyncManager syncManager = syncTargetProxies.length < 1 ? this.createSyncManager(frameRate, syncSourceProxies, wrapperInputBuffers, wrapper, context) : this.createSyncManager(frameRate, syncSourceProxies, wrapperInputBuffers, syncTargetProxies);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SyncManager: " + syncManager);
        }
        if ((minBufferFrames = (int)((double)frameRate * this.minSyncMillis / 1000.0)) < minSyncBufferFrames) {
            minBufferFrames = minSyncBufferFrames;
        }
        SyncSource[] syncSources = new SyncSource[sourceCount];
        for (int i = 0; i < sourceCount; ++i) {
            int bufSize;
            int syncBufferFrames;
            SyncSourceProxy syncSourceWrapper = syncSourceProxies[i];
            WrapperOutputPort sourcePort = syncSourceWrapper.getSourcePort();
            Wrapper sourceWrapper = sourcePort.getWrapper();
            bufferProxy = sourcePort.getSampleBufferProxy();
            if (bufferProxy == null) {
                throw new AudioException("SampleBufferProxy not available for source port: " + sourcePort);
            }
            SampleBuffer sourceBuffer = bufferProxy.getSampleBuffer();
            if (sourceBuffer == null) {
                throw new AudioException("SampleBuffer not available for source port: " + sourcePort);
            }
            String name = sourcePort.getAudioOutputPort().getName();
            for (syncBufferFrames = bufSize = sourceWrapper.getBufferSize(); syncBufferFrames < minBufferFrames; syncBufferFrames *= 2) {
            }
            int channels = sourcePort.getChannels();
            int samples = syncBufferFrames * channels;
            DoubleArrayRingSampleBuffer cb = new DoubleArrayRingSampleBuffer(channels, samples, frameRate, new double[samples]);
            syncSources[i] = new DefaultSyncSource(name, sourceBuffer, cb, syncManager, this.debug);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Initializing SyncManager: " + syncManager);
        }
        syncManager.init(syncSources);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SyncManager initialized: " + syncManager);
        }
        return syncManager;
    }

    protected SyncManager createSyncManager(float frameRate, SyncSourceProxy[] syncSourceWrappers, SampleBuffer[] wrapperInputBuffers, Wrapper wrapper, AudioContextImpl context) throws AudioException {
        AudioEngine wrapperEngine = wrapper.getAudioEngine();
        if (!(wrapperEngine instanceof SyncAudioEngine)) {
            throw new AudioException("Invalid sync audio engine: group=" + wrapper.getGroup() + ", engine=" + wrapperEngine);
        }
        SyncAudioEngine syncEngine = (SyncAudioEngine)wrapperEngine;
        AudioProcessor[] processors = syncEngine.createAudioProcessors(context);
        int sources = syncSourceWrappers.length;
        return new SourceSyncManager(frameRate, sources, wrapperInputBuffers, processors);
    }

    protected SyncManager createSyncManager(float frameRate, SyncSourceProxy[] syncSourceWrappers, SampleBuffer[] wrapperInputBuffers, SyncTargetProxy[] syncTargetWrappers) throws AudioException {
        if (syncTargetWrappers.length < 1) {
            throw new IllegalArgumentException("Invalid number of targets: " + syncTargetWrappers.length);
        }
        if (syncTargetWrappers.length == 1) {
            return this.createSyncTarget(frameRate, syncSourceWrappers, wrapperInputBuffers, syncTargetWrappers[0]);
        }
        throw new UnsupportedOperationException("Multiple sync targets are not supported: " + syncTargetWrappers.length);
    }

    protected abstract SyncTarget createSyncTarget(float var1, SyncSourceProxy[] var2, SampleBuffer[] var3, SyncTargetProxy var4) throws AudioException;
}

