/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.waxmonster.audio.AudioContext;
import com.waxmonster.audio.AudioEngine;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AbstractAudioEngine;
import com.waxmonster.audio.impl.SyncManagerStrategy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AudioContextImpl
implements AudioContext {
    private static final Logger logger = Logger.getLogger(AudioContextImpl.class.getName());
    private final Studio studio;
    private final AbstractAudioEngine ownerEngine;
    private final SyncManagerStrategy syncManagerStrategy;
    private Map wrapperMap;
    private List wrapperList;

    protected AudioContextImpl(Studio studio, AbstractAudioEngine owner, SyncManagerStrategy syncManagerStrategy) {
        this.studio = studio;
        this.ownerEngine = owner;
        this.syncManagerStrategy = syncManagerStrategy;
        this.wrapperMap = new HashMap();
        this.wrapperList = new LinkedList();
    }

    public final Studio getStudio() {
        return this.studio;
    }

    public final AudioEngine getOwnerEngine() {
        return this.ownerEngine;
    }

    public final SyncManagerStrategy getSyncManagerStrategy() {
        return this.syncManagerStrategy;
    }

    public String toString() {
        return super.toString() + "[" + this.ownerEngine + "]";
    }

    public synchronized Wrapper getGroupWrapper(AudioSyncGroup group) {
        int i;
        Wrapper wrapper = (Wrapper)this.wrapperMap.get(group);
        if (wrapper != null) {
            return wrapper;
        }
        AudioSyncGroup[] groups = this.getAudioSyncGroupsRecursive(group);
        Wrapper[] wrappers = new Wrapper[groups.length];
        for (i = 0; i < groups.length; ++i) {
            AudioSyncGroup asg = groups[i];
            Wrapper sgw = (Wrapper)this.wrapperMap.get(asg);
            if (sgw == null) {
                sgw = new Wrapper(asg);
                this.wrapperMap.put(asg, sgw);
                this.wrapperList.add(sgw);
            }
            wrappers[i] = sgw;
        }
        for (i = 0; i < wrappers.length; ++i) {
            Wrapper sgw = wrappers[i];
            int inputCount = sgw.getInputPortCount();
            for (int k = 0; k < inputCount; ++k) {
                Wrapper sourceWrapper;
                AudioSyncGroup sourceGroup;
                WrapperInputPort inputPort = sgw.getInputPortAt(k);
                AudioInputPort audioInputPort = inputPort.getAudioInputPort();
                AudioOutputPort sourceAudioPort = audioInputPort.getSourcePort();
                if (sourceAudioPort == null || (sourceGroup = this.getAudioSyncGroup((AudioPort)sourceAudioPort)) == null || (sourceWrapper = (Wrapper)this.wrapperMap.get(sourceGroup)) == null) continue;
                WrapperOutputPort sourcePort = sourceWrapper.getOutputPort(sourceAudioPort);
                inputPort.setSourcePort(sourcePort);
            }
            int outputCount = sgw.getOutputPortCount();
            for (int k = 0; k < outputCount; ++k) {
                WrapperOutputPort outputPort = sgw.getOutputPortAt(k);
                AudioOutputPort audioOutputPort = outputPort.getAudioOutputPort();
                AudioInputPort[] targetAudioPorts = this.getTargetAudioInputPorts(audioOutputPort);
                ArrayList<WrapperInputPort> targetPortList = new ArrayList<WrapperInputPort>();
                for (int p = 0; p < targetAudioPorts.length; ++p) {
                    WrapperInputPort targetPort;
                    Wrapper destWrapper;
                    AudioInputPort destPort = targetAudioPorts[p];
                    AudioSyncGroup destGroup = this.getAudioSyncGroup((AudioPort)destPort);
                    if (destGroup == null || (destWrapper = (Wrapper)this.wrapperMap.get(destGroup)) == null || (targetPort = destWrapper.getInputPort(destPort)) == null) continue;
                    targetPortList.add(targetPort);
                }
                WrapperInputPort[] targetPortArray = targetPortList.toArray(new WrapperInputPort[targetPortList.size()]);
                outputPort.setTargetPorts(targetPortArray);
            }
        }
        return (Wrapper)this.wrapperMap.get(group);
    }

    public synchronized Wrapper[] getGroupWrappers() {
        return this.wrapperList.toArray(new Wrapper[this.wrapperList.size()]);
    }

    public void dumpAudioContext() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Audio context: " + this);
            if (logger.isLoggable(Level.FINE)) {
                Wrapper[] wrappers = this.getGroupWrappers();
                logger.fine("AudioSyncGroup(s): " + wrappers.length);
                for (int i = 0; i < wrappers.length; ++i) {
                    Wrapper wrapper = wrappers[i];
                    logger.fine(" - AudioSyncGroup #" + i + ": group=" + wrapper.getGroup() + ", engine=" + wrapper.getAudioEngine() + ", syncManager=" + wrapper.getSyncManagerProxy() + ", frameRate=" + wrapper.getFrameRate() + ", bufferSize=" + wrapper.getBufferSize());
                    if (!logger.isLoggable(Level.FINER)) continue;
                    int inputCount = wrapper.getInputPortCount();
                    for (int k = 0; k < inputCount; ++k) {
                        WrapperInputPort port = wrapper.getInputPortAt(k);
                        logger.finer("   - Input #" + k + ": buffer=" + port.getSampleBufferProxy() + ", port=" + port.getAudioInputPort());
                    }
                    int outputCount = wrapper.getOutputPortCount();
                    for (int k = 0; k < outputCount; ++k) {
                        WrapperOutputPort port = wrapper.getOutputPortAt(k);
                        logger.finer("   - Output #" + k + ": buffer=" + port.getSampleBufferProxy() + ", port=" + port.getAudioOutputPort());
                    }
                }
            }
        }
    }

    private final AudioSyncGroup getAudioSyncGroup(AudioPort audioPort) {
        Device device = audioPort.getDevice();
        if (device == null) {
            return null;
        }
        if (!device.isEnabled()) {
            return null;
        }
        AudioSupport support = audioPort.getAudioSupport();
        if (support == null) {
            return null;
        }
        return support.getAudioSyncGroup(audioPort);
    }

    private final AudioInputPort[] getTargetAudioInputPorts(AudioOutputPort port) {
        LinkedList<AudioInputPort> targetPorts = new LinkedList<AudioInputPort>();
        Connection[] conns = port.getConnections();
        for (int k = 0; k < conns.length; ++k) {
            Port partner = conns[k].getPartner((Port)port);
            if (partner == null || !(partner instanceof AudioInputPort)) continue;
            AudioInputPort destPort = (AudioInputPort)partner;
            targetPorts.add(destPort);
        }
        return targetPorts.toArray(new AudioInputPort[targetPorts.size()]);
    }

    private final AudioSyncGroup[] getAudioSyncGroupsRecursive(AudioSyncGroup group) {
        HashSet<AudioSyncGroup> groupSet = new HashSet<AudioSyncGroup>();
        groupSet.add(group);
        LinkedList<AudioSyncGroup> groupList = new LinkedList<AudioSyncGroup>();
        groupList.add(group);
        int groupIndex = 0;
        this.getAudioSyncGroupsRecursive(group, groupSet, groupList, groupIndex);
        return groupList.toArray(new AudioSyncGroup[groupList.size()]);
    }

    private final int getAudioSyncGroupsRecursive(AudioSyncGroup group, Set groupSet, List groupList, int groupIndex) {
        int insertCount = 0;
        int inputCount = group.getInputPortCount();
        for (int i = 0; i < inputCount; ++i) {
            AudioSyncGroup sourceGroup;
            AudioOutputPort sourcePort;
            Device dev;
            AudioInputPort port = group.getInputPortAt(i);
            if (port == null || (dev = port.getDevice()) == null || !dev.isEnabled() || (sourcePort = port.getSourcePort()) == null || (sourceGroup = this.getAudioSyncGroup((AudioPort)sourcePort)) == null || !groupSet.add(sourceGroup)) continue;
            groupList.add(groupIndex, sourceGroup);
            int added = 1 + this.getAudioSyncGroupsRecursive(sourceGroup, groupSet, groupList, groupIndex);
            insertCount += added;
            groupIndex += added;
        }
        int insertIndex = groupIndex + 1;
        int outputCount = group.getOutputPortCount();
        for (int i = 0; i < outputCount; ++i) {
            Device dev;
            AudioOutputPort port = group.getOutputPortAt(i);
            if (port == null || (dev = port.getDevice()) == null || !dev.isEnabled()) continue;
            AudioInputPort[] targetPorts = this.getTargetAudioInputPorts(port);
            for (int k = 0; k < targetPorts.length; ++k) {
                AudioInputPort destPort = targetPorts[k];
                AudioSyncGroup destGroup = this.getAudioSyncGroup((AudioPort)destPort);
                if (destGroup == null || !groupSet.add(destGroup)) continue;
                groupList.add(insertIndex, destGroup);
                int added = 1 + this.getAudioSyncGroupsRecursive(destGroup, groupSet, groupList, insertIndex);
                insertCount += added;
                insertIndex += added;
            }
        }
        return insertCount;
    }
}

