/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.AbstractSyncManager;
import com.waxmonster.audio.impl.SyncSource;
import com.waxmonster.audio.impl.SyncTarget;
import com.waxmonster.audio.impl.SyncTargetProxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingSyncTarget
extends AbstractSyncManager
implements SyncTarget {
    private static final Logger logger = Logger.getLogger(BlockingSyncTarget.class.getName());
    private final String name;
    private final SampleBuffer[] dst;
    private boolean flush;
    private int proc;

    public BlockingSyncTarget(String name, float frameRate, int sources, SampleBuffer[] buffers) {
        super(frameRate, sources);
        this.name = name;
        this.dst = buffers;
        this.flush = false;
        this.proc = 0;
        if (buffers.length != sources) {
            throw new IllegalArgumentException("Invalid number of buffers: " + buffers.length + " != " + sources);
        }
        for (int i = 0; i < sources; ++i) {
            if (this.dst[i] != null) continue;
            throw new IllegalArgumentException("Missing target sample buffer at index " + i);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    @Override
    public AudioProcessor getSyncTargetPreProcessor(SyncTargetProxy syncTargetWrapper) throws AudioException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sync(SyncSource source, long time, int frames) throws AudioException {
        int rc;
        int nf = frames;
        BlockingSyncTarget blockingSyncTarget = this;
        synchronized (blockingSyncTarget) {
            source.todo += nf;
            rc = source.done;
            source.done = 0;
            this.notify();
        }
        return rc;
    }

    @Override
    public synchronized void flush(SyncSource source) throws AudioException {
        this.flush = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(long time, int frames) throws AudioException {
        int i;
        int af;
        int nf = frames;
        while (true) {
            BlockingSyncTarget blockingSyncTarget = this;
            synchronized (blockingSyncTarget) {
                af = 0x1000000;
                for (i = 0; i < this.sn; ++i) {
                    SyncSource s = this.src[i];
                    s.todo -= this.proc;
                    s.done += this.proc;
                    if (s.resync) {
                        this.resync(s);
                    }
                    if (s.todo >= af) continue;
                    af = s.todo;
                }
                if (af >= nf) break;
                if (this.flush) {
                    this.proc = af;
                    if (af > 0) {
                        for (i = 0; i < this.sn; ++i) {
                            this.src[i].copy(this.dst[i], af);
                        }
                    }
                    nf -= af;
                    i = 0;
                    while (true) {
                        if (i >= this.sn) {
                            return;
                        }
                        this.src[i].clear(this.dst[i], af, nf);
                        ++i;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.proc = 0;
            }
        }
        {
            this.proc = af = nf;
        }
        i = 0;
        while (i < this.sn) {
            this.src[i].copy(this.dst[i], af);
            ++i;
        }
        return;
    }

    public synchronized void shutdown() throws AudioException {
        this.flush = true;
        this.notify();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SyncTarget stopped: " + this);
        }
    }
}

