/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.AbstractSyncManager;
import com.waxmonster.audio.impl.SyncSource;
import com.waxmonster.audio.impl.SyncTarget;
import com.waxmonster.audio.impl.SyncTargetProxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedSyncTarget
extends AbstractSyncManager
implements SyncTarget,
Runnable {
    private static final Logger logger = Logger.getLogger(BufferedSyncTarget.class.getName());
    private final String name;
    private final SampleBuffer[] dst;
    private boolean flush;
    private ThreadManager threadManager;
    private int threadPrio;
    private Thread thread;
    private final Object lock;
    private int todo;
    private int drops;

    public BufferedSyncTarget(String name, float frameRate, int sources, SampleBuffer[] buffers, ThreadManager threadManager, int threadPrio) {
        super(frameRate, sources);
        this.name = name;
        this.dst = buffers;
        this.flush = false;
        this.threadManager = threadManager;
        this.threadPrio = threadPrio;
        this.lock = new Object();
        this.todo = 0;
        this.drops = 0;
        if (buffers.length != sources) {
            throw new IllegalArgumentException("Invalid number of buffers: " + buffers.length + " != " + sources);
        }
        for (int i = 0; i < sources; ++i) {
            if (this.dst[i] != null) continue;
            throw new IllegalArgumentException("Missing target sample buffer at index " + i);
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", drops=" + this.drops + "]";
    }

    @Override
    public AudioProcessor getSyncTargetPreProcessor(SyncTargetProxy syncTargetWrapper) throws AudioException {
        return this;
    }

    @Override
    public synchronized void init(SyncSource[] sources) throws AudioException {
        if (this.thread != null) {
            throw new IllegalStateException("SyncTarget thread is already initialized: " + this.thread);
        }
        super.init(sources);
        this.thread = new Thread((Runnable)this, this.name);
        this.thread.setPriority(this.threadPrio);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sync(SyncSource source, long time, int frames) throws AudioException {
        int rc;
        BufferedSyncTarget bufferedSyncTarget = this;
        synchronized (bufferedSyncTarget) {
            source.todo += frames;
            rc = source.done;
            source.done = 0;
            this.notify();
        }
        return rc;
    }

    @Override
    public synchronized void flush(SyncSource source) throws AudioException {
        this.flush = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object;
        int done;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SyncTarget thread started: " + this);
            }
            if (this.threadManager != null) {
                this.threadManager.registerThread(Thread.currentThread());
            }
            done = 0;
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        while (true) {
            int af;
            object = this;
            synchronized (object) {
                af = 0x1000000;
                for (int i = 0; i < this.sn; ++i) {
                    SyncSource s = this.src[i];
                    s.todo -= done;
                    s.done += done;
                    if (s.resync) {
                        this.resync(s);
                    }
                    if (s.todo >= af) continue;
                    af = s.todo;
                }
                if (af < 1) {
                    if (this.flush) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    done = 0;
                    continue;
                }
            }
            object = this.lock;
            synchronized (object) {
                this.todo += af;
                done = af;
            }
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SyncTarget thread stopped: " + this);
            }
            if (this.threadManager != null) {
                this.threadManager.unregisterThread(Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, int frames) throws AudioException {
        int nf = frames;
        Object object = this.lock;
        synchronized (object) {
            if (this.todo >= nf) {
                for (int i = 0; i < this.sn; ++i) {
                    this.src[i].copy(this.dst[i], nf);
                }
                this.todo -= nf;
                return;
            }
        }
        ++this.drops;
        for (int i = 0; i < this.sn; ++i) {
            this.src[i].clear(this.dst[i], 0, nf);
        }
    }

    public synchronized void shutdown() throws AudioException {
        this.flush = true;
        this.notify();
    }
}

