/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.DoubleArrayRingSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.impl.SyncManager;
import com.waxmonster.audio.impl.SyncSource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultSyncSource
extends SyncSource {
    private static final Logger logger = Logger.getLogger(DefaultSyncSource.class.getName());
    private final SampleBuffer sb;
    private final boolean debug;
    private int tail;
    private int size;

    public DefaultSyncSource(String name, SampleBuffer sb, DoubleArrayRingSampleBuffer cb, SyncManager sm, boolean debug) {
        super(name, sb, cb, sm);
        this.sb = sb;
        this.debug = debug;
        this.tail = 0;
        this.size = 0;
    }

    public void process(long time, int frames) throws AudioException {
        int n = frames * this.nc;
        int to = this.tail + n;
        if (this.size + n > this.len) {
            if (this.debug && logger.isLoggable(Level.FINER)) {
                logger.finer("DEBUG: Sync buffer overflow: source=" + this + ", (" + this.size + " + " + n + " > " + this.len + ")");
            }
            if (n > this.len || n < 1) {
                throw new AudioException("Invalid number of input samples: samples=" + n + ", bufferSize=" + this.len);
            }
            this.resync = true;
        }
        if (to <= this.len) {
            this.sb.get(0, this.ca, this.tail, n);
        } else {
            int z = this.len - this.tail;
            this.sb.get(0, this.ca, this.tail, z);
            this.sb.get(z, this.ca, 0, n - z);
        }
        this.tail = to % this.len;
        this.size += n - this.sm.sync(this, time, frames) * this.nc;
    }
}

