/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.AbstractSyncManager;
import com.waxmonster.audio.impl.SyncSource;
import com.waxmonster.audio.impl.SyncTarget;
import com.waxmonster.audio.impl.SyncTargetProxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectSyncTarget
extends AbstractSyncManager
implements SyncTarget {
    private static final Logger logger = Logger.getLogger(DirectSyncTarget.class.getName());
    private final String name;
    private final SampleBuffer[] dst;
    private boolean flush;
    private int proc;
    private int events;
    private int drops;

    public DirectSyncTarget(String name, float frameRate, int sources, SampleBuffer[] buffers) {
        super(frameRate, sources);
        this.name = name;
        this.dst = buffers;
        this.flush = false;
        this.proc = 0;
        this.events = 0;
        this.drops = 0;
        if (buffers.length != sources) {
            throw new IllegalArgumentException("Invalid number of buffers: " + buffers.length + " != " + sources);
        }
        for (int i = 0; i < sources; ++i) {
            if (this.dst[i] != null) continue;
            throw new IllegalArgumentException("Missing target sample buffer at index " + i);
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", sourceEvents=" + this.events + ", targetDrops=" + this.drops + "]";
    }

    @Override
    public AudioProcessor getSyncTargetPreProcessor(SyncTargetProxy syncTargetWrapper) throws AudioException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sync(SyncSource source, long time, int frames) throws AudioException {
        int rc;
        DirectSyncTarget directSyncTarget = this;
        synchronized (directSyncTarget) {
            ++this.events;
            source.todo += frames;
            rc = source.done;
            source.done = 0;
        }
        return rc;
    }

    @Override
    public synchronized void flush(SyncSource source) throws AudioException {
        this.flush = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, int frames) throws AudioException {
        int i;
        int af;
        int nf = frames;
        DirectSyncTarget directSyncTarget = this;
        synchronized (directSyncTarget) {
            af = 0x1000000;
            for (i = 0; i < this.sn; ++i) {
                SyncSource s = this.src[i];
                s.todo -= this.proc;
                s.done += this.proc;
                if (s.resync) {
                    this.resync(s);
                }
                if (s.todo >= af) continue;
                af = s.todo;
            }
            if (af < nf) {
                if (this.flush) {
                    this.proc = af;
                } else {
                    af = 0;
                    this.proc = 0;
                    if (this.events >= this.sn) {
                        ++this.drops;
                    }
                }
            } else {
                af = nf;
                this.proc = nf;
            }
        }
        if (af > 0) {
            for (i = 0; i < this.sn; ++i) {
                this.src[i].copy(this.dst[i], af);
            }
        }
        if (af < nf) {
            nf -= af;
            for (i = 0; i < this.sn; ++i) {
                this.src[i].clear(this.dst[i], af, nf);
            }
        }
    }

    public synchronized void shutdown() throws AudioException {
        this.flush = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SyncTarget stopped: " + this);
        }
    }

    public synchronized int getEvents() {
        return this.events;
    }

    public synchronized int getDrops() {
        return this.drops;
    }
}

