/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperOutputPort;

public class OutputBufferProxy
extends SampleBufferProxy {
    protected final WrapperOutputPort outputPort;
    protected final Wrapper wrapper;

    public OutputBufferProxy(WrapperOutputPort port) {
        super(port);
        this.outputPort = port;
        this.wrapper = port.getWrapper();
    }

    public OutputBufferProxy(WrapperOutputPort port, SampleBuffer sampleBuffer) {
        super(port, sampleBuffer);
        this.outputPort = port;
        this.wrapper = port.getWrapper();
    }

    @Override
    public synchronized SampleBuffer getSampleBuffer() throws AudioException {
        SampleBuffer sb = super.getSampleBuffer();
        if (sb == null) {
            sb = this.createSampleBuffer();
            super.setSampleBuffer(sb);
        }
        return sb;
    }

    @Override
    public synchronized void setSampleBuffer(SampleBuffer sb) throws AudioException {
        super.setSampleBuffer(sb);
    }

    protected SampleBuffer createSampleBuffer() throws AudioException {
        int channels = this.outputPort.getChannels();
        if (channels <= 0) {
            throw new AudioException("Invalid number of channels: port=" + this.outputPort.getAudioPort() + ", channels=" + channels);
        }
        float frameRate = this.wrapper.getFrameRate();
        if (frameRate <= 0.0f) {
            throw new AudioException("Invalid frame rate: port=" + this.outputPort.getAudioPort() + ", frameRate=" + frameRate);
        }
        int bufferSize = this.wrapper.getBufferSize();
        if (bufferSize <= 0) {
            throw new AudioException("Invalid buffer size: port=" + this.outputPort.getAudioPort() + ", bufferSize=" + bufferSize);
        }
        int samples = bufferSize * channels;
        return new DoubleArraySampleBuffer(channels, samples, frameRate, new double[samples]);
    }
}

