/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;

public class SourceBufferProxy
extends SampleBufferProxy {
    protected final WrapperOutputPort source;

    public SourceBufferProxy(WrapperInputPort port, WrapperOutputPort source) {
        super(port);
        this.source = source;
    }

    @Override
    public synchronized SampleBuffer getSampleBuffer() throws AudioException {
        SampleBuffer sb = super.getSampleBuffer();
        if (sb == null) {
            SampleBufferProxy sourceBufferProxy = this.source.getSampleBufferProxy();
            if (sourceBufferProxy == null) {
                throw new AudioException("Source SampleBufferProxy not available for port: " + this.source.getAudioOutputPort());
            }
            sb = sourceBufferProxy.getSampleBuffer();
            if (sb == null) {
                throw new AudioException("Source SampleBuffer not available for port: " + this.source.getAudioOutputPort());
            }
            super.setSampleBuffer(sb);
        }
        return sb;
    }

    @Override
    public void setSampleBuffer(SampleBuffer sb) throws AudioException {
        throw new UnsupportedOperationException("Cannot set source SampleBuffer!");
    }

    @Override
    public String toString() {
        return super.toString() + "[port=" + this.port.getAudioPort() + ", source=" + this.source.getAudioPort() + ", buffer=" + this.sampleBuffer + "]";
    }
}

