/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.AbstractSyncManager;
import com.waxmonster.audio.impl.SyncSource;
import com.waxmonster.audio.impl.SyncTargetProxy;

public class SourceSyncManager
extends AbstractSyncManager {
    private int wc;
    private final SampleBuffer[] dst;
    private final int pf;
    private final AudioProcessor[] pr;
    private final int pn;
    private int flushCount;

    public SourceSyncManager(float frameRate, int sources, SampleBuffer[] buffers, AudioProcessor[] processors) throws AudioException {
        super(frameRate, sources);
        if (sources < 2) {
            throw new IllegalArgumentException("Invalid number of sources: " + sources + " < 2");
        }
        this.wc = this.sn;
        this.dst = buffers;
        int min = this.dst[0].getSamples() / this.dst[0].getChannels();
        for (int i = 1; i < this.sn; ++i) {
            SampleBuffer sb = this.dst[i];
            if (sb.getFrameRate() != frameRate) {
                throw new AudioException("Invalid sample buffer frame rate: " + sb.getFrameRate() + " != " + frameRate);
            }
            int frames = sb.getSamples() / sb.getChannels();
            if (frames >= min) continue;
            min = frames;
        }
        this.pf = min;
        this.pr = processors;
        this.pn = processors.length;
    }

    @Override
    public AudioProcessor getSyncTargetPreProcessor(SyncTargetProxy syncTargetWrapper) throws AudioException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sync(SyncSource source, long time, int frames) throws AudioException {
        int rc;
        long t = time;
        int nf = frames;
        SourceSyncManager sourceSyncManager = this;
        synchronized (sourceSyncManager) {
            SyncSource s;
            int i;
            rc = source.done;
            if (source.todo > 0) {
                source.todo += nf;
                source.done = 0;
                return rc;
            }
            source.todo = nf;
            source.time = t;
            if (--this.wc > 0) {
                source.done = 0;
                return rc;
            }
            nf = 0x1000000;
            for (i = 0; i < this.sn; ++i) {
                s = this.src[i];
                if (s.resync) {
                    this.resync(s);
                }
                if (s.todo >= nf) continue;
                nf = s.todo;
            }
            while (nf > this.pf) {
                for (i = 0; i < this.sn; ++i) {
                    this.src[i].sync(this.dst[i], this.pf);
                }
                i = 0;
                while (i < this.pn) {
                    this.pr[i++].process(t, this.pf);
                }
                nf -= this.pf;
            }
            for (i = 0; i < this.sn; ++i) {
                s = this.src[i];
                s.sync(this.dst[i], nf);
                if (s.todo >= 1) continue;
                ++this.wc;
            }
            rc = source.done;
            source.done = 0;
        }
        int i = 0;
        while (i < this.pn) {
            this.pr[i++].process(t, nf);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(SyncSource source) throws AudioException {
        SourceSyncManager sourceSyncManager = this;
        synchronized (sourceSyncManager) {
            if (++this.flushCount >= this.sn) {
                for (int i = 0; i < this.pn; ++i) {
                    this.pr[i].shutdown();
                }
            }
        }
    }
}

