/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.SyncManagerProxy;
import com.waxmonster.audio.impl.SyncSourceProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;

public class SyncBufferProxy
extends SampleBufferProxy {
    protected final WrapperInputPort inputPort;
    protected final SyncSourceProxy syncSourceProxy;

    public SyncBufferProxy(WrapperInputPort port, SyncSourceProxy syncSourceProxy) {
        super(port);
        this.inputPort = port;
        this.syncSourceProxy = syncSourceProxy;
    }

    @Override
    public synchronized SampleBuffer getSampleBuffer() throws AudioException {
        SampleBuffer sb = super.getSampleBuffer();
        if (sb == null) {
            int channels = this.port.getChannels();
            if (channels <= 0) {
                throw new AudioException("Invalid number of channels: port=" + this.port + ", channels=" + channels);
            }
            SyncManagerProxy syncManagerProxy = this.syncSourceProxy.getSyncManagerProxy();
            Wrapper wrapper = syncManagerProxy.getWrapper();
            float frameRate = wrapper.getFrameRate();
            if (frameRate <= 0.0f) {
                throw new AudioException("Invalid frame rate: port=" + this.port + ", frameRate=" + frameRate);
            }
            int bufferSize = wrapper.getBufferSize();
            if (bufferSize <= 0) {
                throw new AudioException("Invalid buffer size: port=" + this.port + ", bufferSize=" + bufferSize);
            }
            int samples = bufferSize * channels;
            sb = new DoubleArraySampleBuffer(channels, samples, frameRate, new double[samples]);
            super.setSampleBuffer(sb);
        }
        return sb;
    }

    @Override
    public void setSampleBuffer(SampleBuffer sb) throws AudioException {
        throw new UnsupportedOperationException("Cannot set sync SampleBuffer!");
    }
}

