/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.waxmonster.audio.AudioEngine;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.AudioContextImpl;
import com.waxmonster.audio.impl.SyncManager;
import com.waxmonster.audio.impl.SyncManagerStrategy;
import com.waxmonster.audio.impl.SyncSource;
import com.waxmonster.audio.impl.SyncSourceProxy;
import com.waxmonster.audio.impl.SyncTargetProxy;
import com.waxmonster.audio.impl.Wrapper;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncManagerProxy {
    private static final Logger logger = Logger.getLogger(SyncManagerProxy.class.getName());
    private final Wrapper wrapper;
    private final AudioEngine wrapperEngine;
    private final AudioContextImpl context;
    private final SyncManagerStrategy strategy;
    private List syncSourceWrappers;
    private List syncTargetWrappers;
    private SyncManager syncManager;

    public SyncManagerProxy(Wrapper wrapper, AudioEngine wrapperEngine, AudioContextImpl context, SyncManagerStrategy strategy) {
        this.wrapper = wrapper;
        this.wrapperEngine = wrapperEngine;
        this.context = context;
        this.strategy = strategy;
        this.syncSourceWrappers = new LinkedList();
        this.syncTargetWrappers = new LinkedList();
    }

    public final Wrapper getWrapper() {
        return this.wrapper;
    }

    public final AudioEngine getWrapperEngine() {
        return this.wrapperEngine;
    }

    public synchronized void addSyncSourceProxy(SyncSourceProxy ssw) {
        if (this.syncManager != null) {
            throw new IllegalStateException("SyncManager is already initialized: " + this.syncManager);
        }
        this.syncSourceWrappers.add(ssw);
    }

    public synchronized void addSyncTargetProxy(SyncTargetProxy stw) {
        if (this.syncManager != null) {
            throw new IllegalStateException("SyncManager is already initialized: " + this.syncManager);
        }
        this.syncTargetWrappers.add(stw);
    }

    public synchronized boolean resolveFrameRateAndBufferSize() throws AudioException {
        SyncSourceProxy[] sourceWrapperArray = this.syncSourceWrappers.toArray(new SyncSourceProxy[this.syncSourceWrappers.size()]);
        SyncTargetProxy[] targetWrapperArray = this.syncTargetWrappers.toArray(new SyncTargetProxy[this.syncTargetWrappers.size()]);
        return this.strategy.resolveFrameRateAndBufferSize(this.wrapper, sourceWrapperArray, targetWrapperArray);
    }

    public synchronized SyncManager getSyncManager() throws AudioException {
        if (this.syncManager != null) {
            return this.syncManager;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating SyncManager: group=" + this.wrapper.getGroup() + ", strategy=" + this.strategy);
        }
        SyncSourceProxy[] sourceWrapperArray = this.syncSourceWrappers.toArray(new SyncSourceProxy[this.syncSourceWrappers.size()]);
        SyncTargetProxy[] targetWrapperArray = this.syncTargetWrappers.toArray(new SyncTargetProxy[this.syncTargetWrappers.size()]);
        this.syncManager = this.strategy.createSyncManager(this.wrapper, sourceWrapperArray, targetWrapperArray, this.context);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SyncManager: " + this.syncManager);
        }
        return this.syncManager;
    }

    public synchronized SyncSource getSyncSource(SyncSourceProxy syncSourceWrapper) throws AudioException {
        int index = this.syncSourceWrappers.indexOf(syncSourceWrapper);
        if (index < 0) {
            return null;
        }
        return this.getSyncManager().getSyncSourceAt(index);
    }

    public synchronized AudioProcessor getSyncTargetPreProcessor(SyncTargetProxy syncTargetWrapper) throws AudioException {
        int index = this.syncTargetWrappers.indexOf(syncTargetWrapper);
        if (index < 0) {
            return null;
        }
        return this.getSyncManager().getSyncTargetPreProcessor(syncTargetWrapper);
    }
}

