/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.DoubleArrayRingSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.impl.SyncManager;

public abstract class SyncSource
implements AudioProcessor {
    private final String name;
    protected final int nc;
    protected final double[] ca;
    protected final int len;
    protected final SyncManager sm;
    protected volatile boolean resync;
    protected int head;
    protected long time;
    protected int todo;
    protected int done;

    public SyncSource(String name, SampleBuffer sb, DoubleArrayRingSampleBuffer cb, SyncManager sm) {
        this.name = name;
        this.sm = sm;
        this.resync = true;
        this.nc = sb.getChannels();
        this.ca = cb.array();
        this.len = cb.getSamples();
        this.head = 0;
        this.todo = 0;
        this.done = 0;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", syncManager=" + this.sm + "]";
    }

    public void shutdown() throws AudioException {
        this.sm.flush(this);
    }

    public void resync() {
        this.resync = true;
    }

    protected void sync(SampleBuffer dst, int nf) {
        int n = nf * this.nc;
        if (this.head + n <= this.len) {
            dst.set(0, this.ca, this.head, n);
        } else {
            int z = this.len - this.head;
            dst.set(0, this.ca, this.head, z);
            dst.set(z, this.ca, 0, n - z);
        }
        this.head = (this.head + n) % this.len;
        this.todo -= nf;
        this.done += nf;
    }

    protected void copy(SampleBuffer dst, int nf) {
        int n = nf * this.nc;
        if (this.head + n <= this.len) {
            dst.set(0, this.ca, this.head, n);
        } else {
            int z = this.len - this.head;
            dst.set(0, this.ca, this.head, z);
            dst.set(z, this.ca, 0, n - z);
        }
        this.head = (this.head + n) % this.len;
    }

    protected void clear(SampleBuffer dst, int fp, int nf) {
        dst.clear(fp * this.nc, nf * this.nc);
    }

    protected void skip(int nf) {
        this.head = (this.head + nf * this.nc) % this.len;
        this.todo -= nf;
        this.done += nf;
    }

    protected void roll(int nf) {
        this.head = (this.head + nf * this.nc) % this.len;
    }
}

