/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioEngine;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.ProcessorProxy;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.SyncManagerProxy;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Wrapper {
    private static final Logger logger = Logger.getLogger(Wrapper.class.getName());
    private final AudioSyncGroup group;
    private boolean prepared;
    private boolean started;
    private AudioEngine audioEngine;
    private float frameRate;
    private int bufferSize;
    private WrapperInputPort[] inputPorts;
    private WrapperOutputPort[] outputPorts;
    private List preProcessors;
    private List postProcessors;
    private SyncManagerProxy syncManagerProxy;

    protected Wrapper(AudioSyncGroup group) {
        this.group = group;
        this.prepared = false;
        this.started = false;
        this.audioEngine = group.getAudioEngine();
        this.frameRate = -1.0f;
        this.bufferSize = -1;
        this.preProcessors = new LinkedList();
        this.postProcessors = new LinkedList();
        int inputCount = group.getInputPortCount();
        this.inputPorts = new WrapperInputPort[inputCount];
        for (int i = 0; i < inputCount; ++i) {
            AudioInputPort port = group.getInputPortAt(i);
            int channels = port.getChannels();
            this.inputPorts[i] = new WrapperInputPort(this, channels, port);
        }
        int outputCount = group.getOutputPortCount();
        this.outputPorts = new WrapperOutputPort[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            AudioOutputPort port = group.getOutputPortAt(i);
            int channels = port.getChannels();
            this.outputPorts[i] = new WrapperOutputPort(this, channels, port);
        }
    }

    public String toString() {
        return super.toString() + "[group=" + this.group + "]";
    }

    public final AudioSyncGroup getGroup() {
        return this.group;
    }

    public AudioEngine getAudioEngine() {
        return this.audioEngine;
    }

    public void setAudioEngine(AudioEngine audioEngine) {
        if (this.audioEngine == audioEngine) {
            return;
        }
        if (this.audioEngine != null) {
            throw new IllegalStateException("Another AudioEngine is already responsible: " + this.audioEngine);
        }
        this.audioEngine = audioEngine;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(float frameRate) {
        this.frameRate = frameRate;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getInputPortCount() {
        return this.inputPorts.length;
    }

    public WrapperInputPort getInputPortAt(int index) {
        return this.inputPorts[index];
    }

    public WrapperInputPort getInputPort(AudioInputPort audioPort) {
        for (int i = 0; i < this.inputPorts.length; ++i) {
            if (this.inputPorts[i].getAudioPort() != audioPort) continue;
            return this.inputPorts[i];
        }
        return null;
    }

    public int getOutputPortCount() {
        return this.outputPorts.length;
    }

    public WrapperOutputPort getOutputPortAt(int index) {
        return this.outputPorts[index];
    }

    public WrapperOutputPort getOutputPort(AudioOutputPort audioPort) {
        for (int i = 0; i < this.outputPorts.length; ++i) {
            if (this.outputPorts[i].getAudioPort() != audioPort) continue;
            return this.outputPorts[i];
        }
        return null;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public ProcessorProxy[] getPreProcessors() {
        return this.preProcessors.toArray(new ProcessorProxy[this.preProcessors.size()]);
    }

    public ProcessorProxy[] getPostProcessors() {
        return this.postProcessors.toArray(new ProcessorProxy[this.postProcessors.size()]);
    }

    public void addPreProcessor(ProcessorProxy wp) {
        this.preProcessors.add(wp);
    }

    public void addPostProcessor(ProcessorProxy wp) {
        this.postProcessors.add(wp);
    }

    public SyncManagerProxy getSyncManagerProxy() {
        return this.syncManagerProxy;
    }

    public void setSyncManagerProxy(SyncManagerProxy syncManagerProxy) {
        this.syncManagerProxy = syncManagerProxy;
    }

    public void validateSampleBuffer(SampleBuffer sb) throws AudioException {
        if (this.frameRate <= 0.0f) {
            throw new AudioException("Invalid frame rate: group=" + this.group + ", frameRate=" + this.frameRate);
        }
        if (this.bufferSize <= 0) {
            throw new AudioException("Invalid buffer size: group=" + this.group + ", bufferSize=" + this.bufferSize);
        }
        float rate = sb.getFrameRate();
        if (rate != this.frameRate) {
            throw new AudioException("Invalid frame rate: " + rate + " != " + this.frameRate + ", group=" + this.group + ", buffer=" + sb);
        }
        int channels = sb.getChannels();
        int samples = sb.getSamples();
        int frames = samples / channels;
        if (frames != this.bufferSize) {
            throw new AudioException("Invalid buffer size: " + frames + " != " + this.bufferSize + ", group=" + this.group + ", buffer=" + sb);
        }
    }

    public AudioProcessor[] createAudioProcessors() throws AudioException {
        int i;
        int k;
        AudioSyncGroup group = this.getGroup();
        int inputCount = this.getInputPortCount();
        SampleBuffer[] inputBuffers = new SampleBuffer[inputCount];
        for (int k2 = 0; k2 < inputCount; ++k2) {
            WrapperInputPort inputPort = this.getInputPortAt(k2);
            WrapperOutputPort sourcePort = inputPort.getSourcePort();
            if (sourcePort == null) {
                inputBuffers[k2] = null;
                continue;
            }
            SampleBufferProxy bufferProxy = inputPort.getSampleBufferProxy();
            if (bufferProxy == null) {
                throw new AudioException("SampleBufferProxy not available for port: " + inputPort.getAudioInputPort());
            }
            inputBuffers[k2] = bufferProxy.getSampleBuffer();
        }
        int outputCount = this.getOutputPortCount();
        SampleBuffer[] outputBuffers = new SampleBuffer[outputCount];
        for (k = 0; k < outputCount; ++k) {
            WrapperOutputPort outputPort = this.getOutputPortAt(k);
            SampleBufferProxy bufferProxy = outputPort.getSampleBufferProxy();
            if (bufferProxy == null) {
                throw new AudioException("SampleBufferProxy not available for port: " + outputPort.getAudioOutputPort());
            }
            outputBuffers[k] = bufferProxy.getSampleBuffer();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating AudioProcessor: group=" + group + ", inputBuffers=" + inputBuffers.length + ", outputBuffers=" + outputBuffers.length);
            if (logger.isLoggable(Level.FINER)) {
                for (k = 0; k < inputBuffers.length; ++k) {
                    logger.finer(" - InputBuffer #" + k + ": " + inputBuffers[k]);
                }
                for (k = 0; k < outputBuffers.length; ++k) {
                    logger.finer(" - OutputBuffer #" + k + ": " + outputBuffers[k]);
                }
            }
        }
        for (i = 0; i < inputBuffers.length; ++i) {
            if (inputBuffers[i] == null) continue;
            this.validateSampleBuffer(inputBuffers[i]);
        }
        for (i = 0; i < outputBuffers.length; ++i) {
            if (outputBuffers[i] == null) {
                throw new AudioException("Output sample buffer not available: group=" + group + ", index=" + i);
            }
            this.validateSampleBuffer(outputBuffers[i]);
        }
        AudioProcessor ap = group.createAudioProcessor(inputBuffers, outputBuffers);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(" - AudioProcessor: " + ap);
        }
        LinkedList<AudioProcessor> list = new LinkedList<AudioProcessor>();
        AudioProcessor[] preProcessors = this.createPreProcessors();
        for (int i2 = 0; i2 < preProcessors.length; ++i2) {
            list.add(preProcessors[i2]);
        }
        if (ap != null) {
            list.add(ap);
        }
        AudioProcessor[] postProcessors = this.createPostProcessors();
        for (int i3 = 0; i3 < postProcessors.length; ++i3) {
            list.add(postProcessors[i3]);
        }
        return list.toArray(new AudioProcessor[list.size()]);
    }

    public AudioProcessor[] createPreProcessors() throws AudioException {
        LinkedList<AudioProcessor> list = new LinkedList<AudioProcessor>();
        for (ProcessorProxy pw : this.preProcessors) {
            AudioProcessor ap;
            if (pw == null || (ap = pw.getAudioProcessor()) == null) continue;
            list.add(ap);
        }
        return list.toArray(new AudioProcessor[list.size()]);
    }

    public AudioProcessor[] createPostProcessors() throws AudioException {
        LinkedList<AudioProcessor> list = new LinkedList<AudioProcessor>();
        for (ProcessorProxy pw : this.postProcessors) {
            AudioProcessor ap;
            if (pw == null || (ap = pw.getAudioProcessor()) == null) continue;
            list.add(ap);
        }
        return list.toArray(new AudioProcessor[list.size()]);
    }
}

