/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.keyboard;

import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.midi.keyboard.MidiKeyboardDevice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class MidiKeyPanel
extends JPanel {
    private static final long serialVersionUID = 8217911224186318364L;
    private static final boolean[] BLACK_NOTE = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    private int firstKeyNote = 36;
    private int keyCount = 60;
    private Color whiteKeyColor = new Color(1.0f, 1.0f, 1.0f);
    private Color whiteKeyPressedColor = new Color(0.8f, 0.8f, 0.8f);
    private Color whiteKeySeparatorColor = new Color(0.6f, 0.6f, 0.6f);
    private Color blackKeyColor = new Color(0.0f, 0.0f, 0.0f);
    private Color blackKeyPressedColor = new Color(0.4f, 0.4f, 0.4f);
    private Color blackKeySeparatorColor = new Color(0.4f, 0.4f, 0.4f);
    private MidiFormatter midiFormatter;
    private MidiKey[] midiKeys;
    private MidiKey pressedKey;
    private MidiKeyboardDevice device;
    private int channel = 0;
    private int attackVelocity = 64;
    private int releaseVelocity = 64;

    public MidiKeyPanel() {
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setPreferredSize(new Dimension(500, 80));
        this.refresh();
    }

    public static void main(String[] args) {
        MidiKeyPanel panel = new MidiKeyPanel();
        JFrame frame = new JFrame("MidiKeyPanel");
        frame.setContentPane(panel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public int getFirstKeyNote() {
        return this.firstKeyNote;
    }

    public void setFirstKeyNote(int firstKeyNote) {
        this.firstKeyNote = firstKeyNote;
        this.refresh();
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public void setKeyCount(int keyCount) {
        this.keyCount = keyCount;
        this.refresh();
    }

    public MidiFormatter getMidiFormatter() {
        if (this.midiFormatter == null) {
            this.midiFormatter = DefaultMidiFormatter.getSharedInstance();
        }
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public synchronized void refresh() {
        MidiKey[] newMidiKeys = new MidiKey[this.keyCount];
        for (int i = 0; i < this.keyCount; ++i) {
            int note = this.firstKeyNote + i;
            boolean black = this.isBlackNote(note);
            newMidiKeys[i] = new MidiKey(note, black, new Rectangle());
        }
        this.midiKeys = newMidiKeys;
        this.validate();
        this.repaint();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        MidiKey[] keys = this.midiKeys;
        int width = this.getWidth();
        int height = this.getHeight();
        int whiteKeyCount = 0;
        for (int i = 0; i < keys.length; ++i) {
            int note = this.firstKeyNote + i;
            if (this.isBlackNote(note)) continue;
            ++whiteKeyCount;
        }
        int whiteKeyWidth = width / whiteKeyCount;
        int blackKeyWidth = whiteKeyWidth * 2 / 3;
        int whiteKeyHeight = height;
        int blackKeyHeight = height * 2 / 3;
        int nextX = 0;
        for (int i = 0; i < keys.length; ++i) {
            int h;
            int w;
            int y;
            int x;
            MidiKey key = keys[i];
            boolean black = key.isBlack();
            if (black) {
                x = nextX - blackKeyWidth / 2;
                y = 0;
                w = blackKeyWidth;
                h = blackKeyHeight;
            } else {
                x = nextX;
                y = 0;
                w = whiteKeyWidth;
                h = whiteKeyHeight;
            }
            key.setBounds(new Rectangle(x, y, w, h));
            if (black) continue;
            nextX += whiteKeyWidth;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rect;
        MidiKey key;
        int i;
        super.paintComponent(g);
        MidiKey[] keys = this.midiKeys;
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key.isBlack()) continue;
            rect = key.getBounds();
            if (key.isPressed()) {
                g.setColor(this.whiteKeyPressedColor);
            } else {
                g.setColor(this.whiteKeyColor);
            }
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.whiteKeySeparatorColor);
            g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height);
        }
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (!key.isBlack()) continue;
            rect = key.getBounds();
            if (key.isPressed()) {
                g.setColor(this.blackKeyPressedColor);
            } else {
                g.setColor(this.blackKeyColor);
            }
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.blackKeySeparatorColor);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int y;
        int x = event.getX();
        MidiKey key = this.getMidiKeyAt(x, y = event.getY());
        if (key != null) {
            return this.getMidiFormatter().getNoteKeyName(key.getNote());
        }
        return super.getToolTipText(event);
    }

    public boolean isBlackNote(int note) {
        return BLACK_NOTE[note % 12];
    }

    protected MidiKey getMidiKeyAt(int x, int y) {
        Rectangle rect;
        MidiKey key;
        int i;
        MidiKey[] keys = this.midiKeys;
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (!key.isBlack() || !(rect = key.getBounds()).contains(x, y)) continue;
            return key;
        }
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key.isBlack() || !(rect = key.getBounds()).contains(x, y)) continue;
            return key;
        }
        return null;
    }

    protected void handleMousePressed(MouseEvent ev) {
        if (ev.getButton() == 1) {
            MidiKey key = this.getMidiKeyAt(ev.getX(), ev.getY());
            if (this.pressedKey != null) {
                if (this.pressedKey == key) {
                    return;
                }
                this.releaseKey(this.pressedKey);
            }
            if (key != null) {
                this.pressKey(key);
            }
        }
    }

    protected void handleMouseReleased(MouseEvent ev) {
        if (ev.getButton() == 1) {
            MidiKey key = this.getMidiKeyAt(ev.getX(), ev.getY());
            if (key != null && key.isPressed()) {
                this.releaseKey(key);
            }
            if (this.pressedKey != null) {
                this.releaseKey(this.pressedKey);
            }
            this.validate();
            this.repaint();
        }
    }

    protected void handleMouseMoved(MouseEvent ev) {
        MidiKey key;
        if (this.pressedKey != null && ((key = this.getMidiKeyAt(ev.getX(), ev.getY())) == null || key == this.pressedKey)) {
            return;
        }
    }

    protected void handleMouseDragged(MouseEvent ev) {
        MidiKey key;
        if (this.pressedKey != null && ((key = this.getMidiKeyAt(ev.getX(), ev.getY())) == null || key == this.pressedKey)) {
            return;
        }
    }

    protected synchronized void pressKey(MidiKey key) {
        if (key.isPressed()) {
            return;
        }
        if (this.pressedKey != null && this.pressedKey != key) {
            MidiKeyboardDevice dev;
            int oldNote = this.pressedKey.getNote();
            this.pressedKey.setPressed(false);
            this.pressedKey = null;
            if (oldNote != key.getNote() && (dev = this.device) != null) {
                dev.fireNoteOff(this.channel, oldNote, this.releaseVelocity);
            }
        }
        key.setPressed(true);
        this.pressedKey = key;
        MidiKeyboardDevice dev = this.device;
        if (dev != null) {
            dev.fireNoteOn(this.channel, key.getNote(), this.attackVelocity);
        }
        this.validate();
        this.repaint();
    }

    protected synchronized void releaseKey(MidiKey key) {
        MidiKeyboardDevice dev;
        if (!key.isPressed() && key != this.pressedKey) {
            return;
        }
        key.setPressed(false);
        if (this.pressedKey == key) {
            this.pressedKey = null;
        }
        if ((dev = this.device) != null) {
            dev.fireNoteOff(this.channel, key.getNote(), this.releaseVelocity);
        }
        this.validate();
        this.repaint();
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getAttackVelocity() {
        return this.attackVelocity;
    }

    public void setAttackVelocity(int attackVelocity) {
        this.attackVelocity = attackVelocity;
    }

    public int getReleaseVelocity() {
        return this.releaseVelocity;
    }

    public void setReleaseVelocity(int releaseVelocity) {
        this.releaseVelocity = releaseVelocity;
    }

    public Color getWhiteKeyColor() {
        return this.whiteKeyColor;
    }

    public void setWhiteKeyColor(Color whiteKeyColor) {
        this.whiteKeyColor = whiteKeyColor;
    }

    public Color getWhiteKeyPressedColor() {
        return this.whiteKeyPressedColor;
    }

    public void setWhiteKeyPressedColor(Color whiteKeyPressedColor) {
        this.whiteKeyPressedColor = whiteKeyPressedColor;
    }

    public Color getWhiteKeySeparatorColor() {
        return this.whiteKeySeparatorColor;
    }

    public void setWhiteKeySeparatorColor(Color whiteKeySeparatorColor) {
        this.whiteKeySeparatorColor = whiteKeySeparatorColor;
    }

    public Color getBlackKeyColor() {
        return this.blackKeyColor;
    }

    public void setBlackKeyColor(Color blackKeyColor) {
        this.blackKeyColor = blackKeyColor;
    }

    public Color getBlackKeyPressedColor() {
        return this.blackKeyPressedColor;
    }

    public void setBlackKeyPressedColor(Color blackKeyPressedColor) {
        this.blackKeyPressedColor = blackKeyPressedColor;
    }

    public Color getBlackKeySeparatorColor() {
        return this.blackKeySeparatorColor;
    }

    public void setBlackKeySeparatorColor(Color blackKeySeparatorColor) {
        this.blackKeySeparatorColor = blackKeySeparatorColor;
    }

    public MidiKeyboardDevice getDevice() {
        return this.device;
    }

    public void setDevice(MidiKeyboardDevice device) {
        this.device = device;
    }

    protected class MouseMotionHandler
    extends MouseMotionAdapter {
        protected MouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            MidiKeyPanel.this.handleMouseMoved(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            MidiKeyPanel.this.handleMouseDragged(e);
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            MidiKeyPanel.this.handleMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            MidiKeyPanel.this.handleMouseReleased(e);
        }
    }

    protected class MidiKey {
        private final int note;
        private final boolean black;
        private Rectangle bounds;
        private boolean pressed;

        public MidiKey(int note, boolean black, Rectangle bounds) {
            this.note = note;
            this.black = black;
            this.bounds = bounds;
        }

        public final int getNote() {
            return this.note;
        }

        public boolean isBlack() {
            return this.black;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }
    }
}

