/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.keyboard;

import com.spacekiller.util.Clock;
import com.waxmonster.midi.MidiContext;
import com.waxmonster.midi.MidiEngine;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.AbstractMidiEngine;
import com.waxmonster.midi.impl.MidiContextImpl;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.impl.MidiProcessorProxy;
import com.waxmonster.midi.impl.Wrapper;
import com.waxmonster.midi.impl.WrapperOutputPort;
import com.waxmonster.midi.keyboard.MidiKeyboardDeviceProvider;
import com.waxmonster.midi.keyboard.MidiKeyboardPanel;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class MidiKeyboardDevice
extends Device {
    private static final Logger logger = Logger.getLogger(MidiKeyboardDevice.class.getName());
    private final MidiSupportImpl support = new MidiSupportImpl();
    private final MidiKeyboardDeviceProvider keyboardDeviceProvider;
    private MidiOutputPort outputPort;
    private Clock clock;
    private MidiProcessor targetProcessor;
    private MidiKeyboardPanel midiKeyboardPanel;

    public MidiKeyboardDevice(MidiKeyboardDeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super((DeviceProvider)provider, name);
        this.setIconColor16(iconColor16);
        this.keyboardDeviceProvider = provider;
        this.outputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.support);
        this.addPort((Port)this.outputPort);
    }

    protected MidiProcessor getTargetMidiProcessor() {
        return this.targetProcessor;
    }

    protected void fireNoteOn(int channel, int note, int velocity) {
        MidiProcessor proc = this.targetProcessor;
        if (proc != null) {
            proc.process(this.clock.nanos(), 0x90 | channel, note, velocity);
        }
    }

    protected void fireNoteOff(int channel, int note, int velocity) {
        MidiProcessor proc = this.targetProcessor;
        if (proc != null) {
            proc.process(this.clock.nanos(), 0x80 | channel, note, velocity);
        }
    }

    public synchronized Component getCustomizer() {
        if (this.midiKeyboardPanel == null) {
            this.midiKeyboardPanel = new MidiKeyboardPanel();
            this.midiKeyboardPanel.setOpaque(false);
            this.midiKeyboardPanel.setDevice(this);
        }
        return this.midiKeyboardPanel;
    }

    protected synchronized void activate() throws StudioException {
        SyncGroupImpl group = this.support.getSyncGroupImpl();
        if (group == null) {
            return;
        }
        EngineImpl engine = group.getEngineImpl();
        if (engine == null) {
            return;
        }
        engine.activateMidiKeyboardDevice(this, group);
    }

    protected synchronized void deactivate() throws StudioException {
        SyncGroupImpl group = this.support.getSyncGroupImpl();
        if (group == null) {
            return;
        }
        EngineImpl engine = group.getEngineImpl();
        if (engine == null) {
            return;
        }
        engine.deactivateMidiKeyboardDevice(this, group);
    }

    protected void applyProperty(String key, String value) {
    }

    protected class EngineImpl
    extends AbstractMidiEngine {
        private MidiSupportImpl theSupport;
        private SyncGroupImpl theGroup;
        private MidiContextImpl theContext;
        private Wrapper theWrapper;

        public EngineImpl(MidiEngineConfig config) {
            super(config);
        }

        public void prepare(MidiSyncGroup group, MidiContext context) throws MidiException {
            MidiContextImpl syncGroupContext = this.getMidiContextImpl(context);
            this.prepareMidiKeyboard(MidiKeyboardDevice.this.support, syncGroupContext);
        }

        public void start() throws MidiException {
            this.startMidiKeyboard();
        }

        final void activateMidiKeyboardDevice(MidiKeyboardDevice device, SyncGroupImpl group) throws StudioException {
            Studio studio = device.getStudio();
            if (studio == null) {
                throw new StudioException("Device is not assigned to a studio: " + (Object)((Object)device));
            }
            MidiContextImpl midiContext = this.createMidiContextImpl(studio);
            boolean prepared = this.prepareMidiKeyboard(MidiKeyboardDevice.this.support, midiContext);
            if (prepared) {
                this.startMidiKeyboard();
            }
        }

        final void deactivateMidiKeyboardDevice(MidiKeyboardDevice device, SyncGroupImpl group) throws StudioException {
            MidiSupportImpl support = device.support;
            if (support == null) {
                return;
            }
            this.stopMidiKeyboard(support);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean prepareMidiKeyboard(MidiSupportImpl support, MidiContextImpl midiContext) throws MidiException {
            Wrapper wrapper;
            SyncGroupImpl syncGroup;
            EngineImpl engineImpl = this;
            synchronized (engineImpl) {
                if (this.theSupport == support) {
                    return false;
                }
                syncGroup = support.getSyncGroupImpl();
                if (syncGroup == null) {
                    throw new MidiException("No MidiSyncGroup available: " + (Object)((Object)support));
                }
                if (this.theGroup == syncGroup) {
                    return false;
                }
                if (this.theSupport != null) {
                    throw new MidiException("MidiEngine is already activated: " + (Object)((Object)this));
                }
                EngineImpl engine = syncGroup.getEngineImpl();
                if (engine != this) {
                    throw new MidiException("Invalid MidiEngine: " + (Object)((Object)engine) + " != " + (Object)((Object)this));
                }
                this.theSupport = support;
                this.theGroup = syncGroup;
                this.theContext = midiContext;
            }
            this.theWrapper = wrapper = midiContext.getGroupWrapper((MidiSyncGroup)syncGroup);
            this.prepareMidiSyncGroup(syncGroup, midiContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MIDI keyboard engine prepared: " + (Object)((Object)MidiKeyboardDevice.this));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startMidiKeyboard() throws MidiException {
            MidiProcessorProxy proxy;
            WrapperOutputPort outPort;
            EngineImpl engineImpl = this;
            synchronized (engineImpl) {
                MidiSupportImpl support = this.theSupport;
                if (support == null) {
                    throw new MidiException("MidiEngine is not prepared: " + (Object)((Object)this));
                }
            }
            if (this.theWrapper.isStarted()) {
                throw new MidiException("MidiEngine is already started: " + (Object)((Object)this));
            }
            if (this.theWrapper.getOutputPortCount() > 0 && (outPort = this.theWrapper.getOutputPortAt(0)) != null && (proxy = outPort.getOutputProxy()) != null) {
                Studio studio = this.theContext.getStudio();
                MidiKeyboardDevice.this.clock = studio.getClock();
                MidiKeyboardDevice.this.targetProcessor = (MidiProcessor)proxy;
            }
            this.theWrapper.setStarted(true);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MIDI keyboard engine started: " + (Object)((Object)MidiKeyboardDevice.this));
            }
            this.startMidiEngines(this.theContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopMidiKeyboard(MidiSupportImpl support) throws MidiException {
            EngineImpl engineImpl = this;
            synchronized (engineImpl) {
                if (this.theGroup == null && this.theSupport == null) {
                    return;
                }
                if (support != this.theSupport) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Ignored invalid MidiSupport: " + (Object)((Object)support) + " != " + (Object)((Object)this.theSupport));
                    }
                    return;
                }
            }
            MidiContextImpl midiContext = this.theContext;
            if (midiContext != null) {
                this.shutdownMidiProcessors(midiContext);
            }
            EngineImpl engineImpl2 = this;
            synchronized (engineImpl2) {
                this.theContext = null;
                this.theGroup = null;
                this.theSupport = null;
                this.theWrapper = null;
            }
            if (support != null) {
                support.reset();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MIDI keyboard engine stopped: " + (Object)((Object)MidiKeyboardDevice.this));
            }
        }
    }

    protected class SyncGroupImpl
    extends MidiSyncGroup {
        private final EngineImpl engineImpl;

        public SyncGroupImpl(String name, MidiOutputPort outputPort, EngineImpl engine) {
            super(name, new MidiInputPort[0], new MidiOutputPort[]{outputPort}, (MidiEngine)engine);
            this.engineImpl = engine;
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target processors: " + targets.length + " != 1");
            }
            MidiKeyboardDevice.this.clock = MidiKeyboardDevice.this.getStudio().getClock();
            MidiKeyboardDevice.this.targetProcessor = targets[0];
        }

        public synchronized MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            return null;
        }

        protected final EngineImpl getEngineImpl() {
            return this.engineImpl;
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        SyncGroupImpl syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (MidiKeyboardDevice.this.targetProcessor != null) {
                MidiKeyboardDevice.this.targetProcessor = null;
            }
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            return this.getSyncGroupImpl();
        }

        protected synchronized SyncGroupImpl getSyncGroupImpl() {
            if (this.syncGroup == null) {
                MidiEngineConfig config = MidiKeyboardDevice.this.keyboardDeviceProvider.getConfig();
                EngineImpl midiEngine = new EngineImpl(config);
                this.syncGroup = new SyncGroupImpl(MidiKeyboardDevice.this.getName(), MidiKeyboardDevice.this.outputPort, midiEngine);
            }
            return this.syncGroup;
        }
    }
}

