/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.keyboard;

import com.spacekiller.util.Tools;
import com.waxmonster.midi.MidiPortType;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.keyboard.MidiKeyboardDevice;
import com.waxmonster.midi.keyboard.MidiKeyboardDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class MidiKeyboardDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "MidiKeyboardDeviceProvider";
    public static final String DEVICE_CATEGORY_NAME = "MIDI Tools";
    private MidiEngineConfig config = new MidiEngineConfig();

    public MidiKeyboardDeviceProvider() {
        super(PROVIDER_NAME);
        this.initCommonMidiDeviceProvider();
    }

    protected void initCommonMidiDeviceProvider() {
        String name = "MIDI Keyboard";
        String tooltip = "MIDI Keyboard";
        Icon midiKeyboardIcon = Tools.getIcon(MidiKeyboardDeviceProvider.class, (String)"/com/waxmonster/midi/keyboard/icons/waxmonster_midi_keyboard_icon16.png");
        MidiKeyboardDeviceInfo midiKeyboard = new MidiKeyboardDeviceInfo(name, tooltip, midiKeyboardIcon);
        this.addDeviceInfo(midiKeyboard);
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (info == null) {
            return null;
        }
        String name = info.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        if (info instanceof MidiKeyboardDeviceInfo) {
            return new MidiKeyboardDevice(this, name, iconColor16);
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        return MidiPortType.getMidiPortType((String)typeName);
    }

    public MidiEngineConfig getConfig() {
        return this.config;
    }

    public void setConfig(MidiEngineConfig config) {
        this.config = config;
    }
}

