/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.help.ContextHelpPane;
import java.awt.Component;
import java.util.Observer;
import java.util.Vector;

public class ContextHelpManager {
    private Vector panes = new Vector();
    private Observer contextComponentObserver;

    public void addContextHelpPane(ContextHelpPane pane) {
        if (pane == null) {
            return;
        }
        if (this.panes.contains(pane)) {
            return;
        }
        this.panes.addElement(pane);
    }

    public void closeContextHelp() {
        int count = this.panes.size();
        for (int c = 0; c < count; ++c) {
            ((ContextHelpPane)this.panes.get(c)).closeContextHelp();
        }
    }

    public void contextHelpStopped(Component component) {
        this.closeContextHelp();
        Observer observer = this.getContextComponentObserver();
        if (observer != null) {
            observer.update(null, component);
        }
    }

    public Observer getContextComponentObserver() {
        return this.contextComponentObserver;
    }

    public void removeContextHelpPane(ContextHelpPane pane) {
        if (pane == null) {
            return;
        }
        this.panes.removeElement(pane);
    }

    public void setContextComponentObserver(Observer newContextComponentObserver) {
        this.contextComponentObserver = newContextComponentObserver;
    }
}

