/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.help.ContextHelp;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import java.util.logging.Logger;

public class DefaultContextHelp
implements ContextHelp {
    private Vector contextNames = new Vector();
    private Vector contextTypes = new Vector();
    private String helpKey;
    private static final Logger logger = Logger.getLogger(DefaultContextHelp.class.getName());

    public DefaultContextHelp(Component component) {
        for (Component comp = component; comp != null; comp = comp.getParent()) {
            this.addContext(comp.getName(), comp.getClass().getName());
        }
    }

    protected synchronized void addContext(String name, String type) {
        this.contextNames.addElement(name == null ? "" : name);
        this.contextTypes.addElement(type == null ? "" : type);
    }

    public void dumpComponent(Component comp) {
        Container parent = comp.getParent();
        if (parent != null) {
            this.dumpComponent(parent);
        }
        logger.fine(" - " + comp.getClass().getName() + " => " + comp.getName());
    }

    @Override
    public int getContextCount() {
        return this.contextNames.size();
    }

    @Override
    public String getContextName(int index) {
        return (String)this.contextNames.get(index);
    }

    @Override
    public String getContextType(int index) {
        return (String)this.contextTypes.get(index);
    }

    @Override
    public String getHelpKey() {
        return this.helpKey;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void setHelpKey(String newHelpKey) {
        this.helpKey = newHelpKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

