/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.Data;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.help.DefaultHelpTreeCellRenderer;
import com.spacekiller.util.help.HelpIndex;
import com.spacekiller.util.help.HelpNode;
import com.spacekiller.util.swing.SimpleWebBrowser;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DefaultHelpManager
extends JPanel {
    private static final long serialVersionUID = 822090078503292254L;
    private JScrollPane ivjJScrollPane1 = null;
    private JSplitPane ivjJSplitPane1 = null;
    private JTree ivjJTree1 = null;
    private SimpleWebBrowser ivjDefaultBrowser1 = null;
    private HelpIndex fieldHelpIndex = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private HelpNode fieldSelectedHelp = null;
    private boolean ivjConnPtoP1Aligning = false;
    private TreeSelectionModel ivjselectionModel1 = null;
    private JMenuItem ivjJMenuItem1 = null;
    private JMenuItem ivjJMenuItem11 = null;
    private JMenuItem ivjJMenuItem12 = null;
    private JMenuItem ivjJMenuItem121 = null;
    private JPopupMenu ivjJPopupMenu1 = null;
    private boolean fieldEditable = false;
    private RuntimeContext fieldRuntimeContext = null;
    private static final Logger logger = Logger.getLogger(DefaultHelpManager.class.getName());

    public DefaultHelpManager() {
        this.initialize();
    }

    private void action_Node_Add() {
        if (!this.getEditable()) {
            return;
        }
        this.createHelpNode("New help", "");
        this.refreshTree();
    }

    private void action_Node_Copy() {
        if (!this.getEditable()) {
            return;
        }
    }

    private void action_Node_Paste() {
        if (!this.getEditable()) {
            return;
        }
    }

    private void action_Node_Remove() {
        if (!this.getEditable()) {
            return;
        }
    }

    private void connEtoC1() {
        try {
            this.defaultHelpManager_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10(ActionEvent arg1) {
        try {
            this.action_Node_Remove();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(PropertyChangeEvent arg1) {
        try {
            this.defaultHelpManager_HelpIndex(this.getHelpIndex());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(PropertyChangeEvent arg1) {
        try {
            this.defaultHelpManager_SelectedHelp(this.getSelectedHelp());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(TreeSelectionEvent arg1) {
        try {
            this.selectionModel1_ValueChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(MouseEvent arg1) {
        try {
            this.jTree1_MouseReleased(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.action_Node_Add();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(PropertyChangeEvent arg1) {
        try {
            this.defaultBrowser1_Url(String.valueOf(this.getDefaultBrowser1().getUrl()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ActionEvent arg1) {
        try {
            this.action_Node_Copy();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ActionEvent arg1) {
        try {
            this.action_Node_Paste();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetSource() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                if (this.getselectionModel1() != null) {
                    this.getJTree1().setSelectionModel(this.getselectionModel1());
                }
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                this.setselectionModel1(this.getJTree1().getSelectionModel());
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getDefaultBrowser1().setRuntimeContext(this.getRuntimeContext());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected DefaultTreeModel createHelpIndexTreeModel(HelpIndex helpIndex) {
        DefaultMutableTreeNode root = this.createHelpIndexTreeNode(helpIndex, helpIndex.getRoot());
        DefaultTreeModel model = new DefaultTreeModel(root);
        return model;
    }

    protected DefaultMutableTreeNode createHelpIndexTreeNode(HelpIndex index, HelpNode help) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(help);
        int count = help.getChildCount();
        for (int c = 0; c < count; ++c) {
            String childKey = help.getChildAt(c);
            HelpNode childNode = index.getHelpNode(childKey);
            if (childNode == null) continue;
            node.add(this.createHelpIndexTreeNode(index, childNode));
        }
        return node;
    }

    protected HelpNode createHelpNode(String name, String url) {
        DefaultMutableTreeNode mutable;
        TreePath path = this.getJTree1().getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = mutable = path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
        if (mutable == null) {
            mutable = (DefaultMutableTreeNode)this.getJTree1().getModel().getRoot();
        }
        if (mutable == null) {
            return null;
        }
        HelpNode parent = (HelpNode)mutable.getUserObject();
        HelpNode newNode = this.getHelpIndex().createHelpNode(name, url);
        newNode.setParent(parent.getKey());
        parent.addChild(newNode.getKey());
        this.getHelpIndex().addHelpNode(newNode);
        return newNode;
    }

    private void defaultBrowser1_Url(String arg1) {
        if (this.getEditable()) {
            Object node;
            HelpNode helpNode;
            TreePath[] paths = this.getJTree1().getSelectionPaths();
            if (paths != null && paths.length == 1 && (helpNode = DefaultHelpManager.getHelpNode(node = paths[0].getLastPathComponent())) != null) {
                helpNode.setURL(arg1 == null ? "" : arg1);
            }
        } else {
            this.getJTree1().clearSelection();
        }
    }

    private void defaultHelpManager_HelpIndex(HelpIndex arg1) {
        DefaultTreeModel model = this.createHelpIndexTreeModel(arg1);
        this.getJTree1().setModel(model);
    }

    private void defaultHelpManager_Initialize() {
        this.getJTree1().setCellRenderer((TreeCellRenderer)((Object)new DefaultHelpTreeCellRenderer()));
        this.getJTree1().setRootVisible(false);
        this.getJTree1().setShowsRootHandles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultHelpManager_SelectedHelp(HelpNode arg1) throws Exception {
        try {
            this.getDefaultBrowser1().removePropertyChangeListener((PropertyChangeListener)this.ivjEventHandler);
            this.getDefaultBrowser1().setURL(arg1 == null ? "" : "" + arg1.getURL());
        }
        finally {
            this.getDefaultBrowser1().addPropertyChangeListener((PropertyChangeListener)this.ivjEventHandler);
        }
    }

    private SimpleWebBrowser getDefaultBrowser1() {
        if (this.ivjDefaultBrowser1 == null) {
            try {
                this.ivjDefaultBrowser1 = new SimpleWebBrowser();
                this.ivjDefaultBrowser1.setName("DefaultBrowser1");
                this.ivjDefaultBrowser1.setOpaque(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultBrowser1;
    }

    public boolean getEditable() {
        return this.fieldEditable;
    }

    public HelpIndex getHelpIndex() {
        return this.fieldHelpIndex;
    }

    public static HelpNode getHelpNode(Object treeNode) {
        DefaultMutableTreeNode mutable;
        Object help;
        Object node = treeNode;
        if (node != null && node instanceof DefaultMutableTreeNode && (help = (mutable = (DefaultMutableTreeNode)node).getUserObject()) != null && help instanceof HelpNode) {
            return (HelpNode)help;
        }
        return null;
    }

    private JMenuItem getJMenuItem1() {
        if (this.ivjJMenuItem1 == null) {
            try {
                this.ivjJMenuItem1 = new JMenuItem();
                this.ivjJMenuItem1.setName("JMenuItem1");
                this.ivjJMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/help/icons/insert.gif")));
                this.ivjJMenuItem1.setText("Add");
                this.ivjJMenuItem1.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItem1;
    }

    private JMenuItem getJMenuItem11() {
        if (this.ivjJMenuItem11 == null) {
            try {
                this.ivjJMenuItem11 = new JMenuItem();
                this.ivjJMenuItem11.setName("JMenuItem11");
                this.ivjJMenuItem11.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/help/icons/delete.gif")));
                this.ivjJMenuItem11.setFont(new Font("dialog", 0, 12));
                this.ivjJMenuItem11.setText("Remove");
                this.ivjJMenuItem11.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItem11;
    }

    private JMenuItem getJMenuItem12() {
        if (this.ivjJMenuItem12 == null) {
            try {
                this.ivjJMenuItem12 = new JMenuItem();
                this.ivjJMenuItem12.setName("JMenuItem12");
                this.ivjJMenuItem12.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/help/icons/copy.gif")));
                this.ivjJMenuItem12.setFont(new Font("dialog", 0, 12));
                this.ivjJMenuItem12.setText("Copy");
                this.ivjJMenuItem12.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItem12;
    }

    private JMenuItem getJMenuItem121() {
        if (this.ivjJMenuItem121 == null) {
            try {
                this.ivjJMenuItem121 = new JMenuItem();
                this.ivjJMenuItem121.setName("JMenuItem121");
                this.ivjJMenuItem121.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/help/icons/paste.gif")));
                this.ivjJMenuItem121.setFont(new Font("dialog", 0, 12));
                this.ivjJMenuItem121.setText("Paste");
                this.ivjJMenuItem121.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItem121;
    }

    protected JPopupMenu getJPopupMenu(HelpNode helpNode) {
        boolean ed = this.getEditable();
        this.getJMenuItem12().setVisible(ed);
        return this.getJPopupMenu1();
    }

    private JPopupMenu getJPopupMenu1() {
        if (this.ivjJPopupMenu1 == null) {
            try {
                this.ivjJPopupMenu1 = new JPopupMenu();
                this.ivjJPopupMenu1.setName("JPopupMenu1");
                this.ivjJPopupMenu1.add(this.getJMenuItem1());
                this.ivjJPopupMenu1.add(this.getJMenuItem12());
                this.ivjJPopupMenu1.add(this.getJMenuItem121());
                this.ivjJPopupMenu1.add(this.getJMenuItem11());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPopupMenu1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getJTree1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JSplitPane getJSplitPane1() {
        if (this.ivjJSplitPane1 == null) {
            try {
                this.ivjJSplitPane1 = new JSplitPane(1);
                this.ivjJSplitPane1.setName("JSplitPane1");
                this.ivjJSplitPane1.setOpaque(false);
                this.getJSplitPane1().add((Component)this.getJScrollPane1(), "left");
                this.getJSplitPane1().add((Component)this.getDefaultBrowser1(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSplitPane1;
    }

    private JTree getJTree1() {
        if (this.ivjJTree1 == null) {
            try {
                this.ivjJTree1 = new JTree();
                this.ivjJTree1.setName("JTree1");
                this.ivjJTree1.setOpaque(false);
                this.ivjJTree1.setBounds(0, 0, 78, 72);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTree1;
    }

    public RuntimeContext getRuntimeContext() {
        return this.fieldRuntimeContext;
    }

    public HelpNode getSelectedHelp() {
        return this.fieldSelectedHelp;
    }

    private TreeSelectionModel getselectionModel1() {
        return this.ivjselectionModel1;
    }

    private void handleException(Throwable exception) {
        logger.fine("--------- UNCAUGHT EXCEPTION ---------");
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void initConnections() throws Exception {
        this.addPropertyChangeListener(this.ivjEventHandler);
        this.getJTree1().addPropertyChangeListener(this.ivjEventHandler);
        this.getJTree1().addMouseListener(this.ivjEventHandler);
        this.getJMenuItem1().addActionListener(this.ivjEventHandler);
        this.getDefaultBrowser1().addPropertyChangeListener((PropertyChangeListener)this.ivjEventHandler);
        this.getJMenuItem12().addActionListener(this.ivjEventHandler);
        this.getJMenuItem121().addActionListener(this.ivjEventHandler);
        this.getJMenuItem11().addActionListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
    }

    private void initialize() {
        try {
            this.setName("DefaultHelpManager");
            this.setLayout(new GridBagLayout());
            this.setSize(498, 312);
            GridBagConstraints constraintsJSplitPane1 = new GridBagConstraints();
            constraintsJSplitPane1.gridx = 0;
            constraintsJSplitPane1.gridy = 0;
            constraintsJSplitPane1.fill = 1;
            constraintsJSplitPane1.weightx = 1.0;
            constraintsJSplitPane1.weighty = 1.0;
            this.add((Component)this.getJSplitPane1(), constraintsJSplitPane1);
            this.initConnections();
            this.connEtoC1();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void jTree1_MouseReleased(MouseEvent mouseEvent) {
        HelpNode helpNode;
        Object node;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        TreePath path = this.getJTree1().getSelectionPath();
        Object object = node = path == null ? null : path.getLastPathComponent();
        if (node == null) {
            node = this.getJTree1().getModel().getRoot();
        }
        if ((helpNode = DefaultHelpManager.getHelpNode(node)) != null) {
            JPopupMenu menu = this.getJPopupMenu(helpNode);
            menu.show(this.getJTree1(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            DefaultHelpManager aDefaultHelpManager = new DefaultHelpManager();
            frame.setContentPane(aDefaultHelpManager);
            frame.setSize(aDefaultHelpManager.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void refreshTree() {
        this.defaultHelpManager_HelpIndex(this.getHelpIndex());
    }

    private void selectionModel1_ValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath path = this.getJTree1().getSelectionPath();
        if (path != null) {
            Object node = path.getLastPathComponent();
            HelpNode helpNode = DefaultHelpManager.getHelpNode(node);
            this.setSelectedHelp(helpNode);
        }
    }

    public void setEditable(boolean editable) {
        boolean oldValue = this.fieldEditable;
        this.fieldEditable = editable;
        this.firePropertyChange("editable", Data.toBoolean((boolean)oldValue), Data.toBoolean((boolean)editable));
    }

    public void setHelpIndex(HelpIndex helpIndex) {
        HelpIndex oldValue = this.fieldHelpIndex;
        this.fieldHelpIndex = helpIndex;
        this.firePropertyChange("helpIndex", oldValue, helpIndex);
    }

    public void setRuntimeContext(RuntimeContext runtimeContext) {
        RuntimeContext oldValue = this.fieldRuntimeContext;
        this.fieldRuntimeContext = runtimeContext;
        this.firePropertyChange("runtimeContext", oldValue, runtimeContext);
    }

    public void setSelectedHelp(HelpNode selectedHelp) {
        HelpNode oldValue = this.fieldSelectedHelp;
        this.fieldSelectedHelp = selectedHelp;
        this.firePropertyChange("selectedHelp", oldValue, selectedHelp);
    }

    private void setselectionModel1(TreeSelectionModel newValue) {
        if (this.ivjselectionModel1 != newValue) {
            try {
                if (this.ivjselectionModel1 != null) {
                    this.ivjselectionModel1.removeTreeSelectionListener(this.ivjEventHandler);
                }
                this.ivjselectionModel1 = newValue;
                if (this.ivjselectionModel1 != null) {
                    this.ivjselectionModel1.addTreeSelectionListener(this.ivjEventHandler);
                }
                this.connPtoP1SetSource();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    class IvjEventHandler
    implements ActionListener,
    MouseListener,
    PropertyChangeListener,
    TreeSelectionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DefaultHelpManager.this.getJMenuItem1()) {
                DefaultHelpManager.this.connEtoC6(e);
            }
            if (e.getSource() == DefaultHelpManager.this.getJMenuItem12()) {
                DefaultHelpManager.this.connEtoC8(e);
            }
            if (e.getSource() == DefaultHelpManager.this.getJMenuItem121()) {
                DefaultHelpManager.this.connEtoC9(e);
            }
            if (e.getSource() == DefaultHelpManager.this.getJMenuItem11()) {
                DefaultHelpManager.this.connEtoC10(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == DefaultHelpManager.this.getJTree1()) {
                DefaultHelpManager.this.connEtoC5(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == DefaultHelpManager.this && evt.getPropertyName().equals("helpIndex")) {
                DefaultHelpManager.this.connEtoC2(evt);
            }
            if (evt.getSource() == DefaultHelpManager.this && evt.getPropertyName().equals("selectedHelp")) {
                DefaultHelpManager.this.connEtoC3(evt);
            }
            if (evt.getSource() == DefaultHelpManager.this.getJTree1() && evt.getPropertyName().equals("selectionModel")) {
                DefaultHelpManager.this.connPtoP1SetTarget();
            }
            if (evt.getSource() == DefaultHelpManager.this.getDefaultBrowser1() && evt.getPropertyName().equals("url")) {
                DefaultHelpManager.this.connEtoC7(evt);
            }
            if (evt.getSource() == DefaultHelpManager.this && evt.getPropertyName().equals("runtimeContext")) {
                DefaultHelpManager.this.connPtoP2SetTarget();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getSource() == DefaultHelpManager.this.getselectionModel1()) {
                DefaultHelpManager.this.connEtoC4(e);
            }
        }
    }
}

