/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.Data;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class LayerLayout
implements LayoutManager {
    public static final int LAYER_BACKGROUND = JLayeredPane.FRAME_CONTENT_LAYER - 1;
    public static final int LAYER_FOREGROUND = JLayeredPane.FRAME_CONTENT_LAYER + 10;
    private Component backPane;
    private LayoutManager parentLayout;

    public LayerLayout(LayoutManager parent, Component background) {
        this.parentLayout = parent;
        this.backPane = background;
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
        if (this.parentLayout != null) {
            this.parentLayout.addLayoutComponent(name, c);
        }
    }

    public static void installLayeredComponent(JLayeredPane layeredPane, int layer, Component component) {
        if (layeredPane == null) {
            return;
        }
        if (component == null) {
            return;
        }
        layeredPane.add(component, Data.toInteger((int)layer));
        layeredPane.setLayout(new LayerLayout(layeredPane.getLayout(), component));
    }

    public static void installRootComponent(JRootPane rootPane, int layer, Component component) {
        if (rootPane == null) {
            return;
        }
        if (component == null) {
            return;
        }
        rootPane.add(component, Data.toInteger((int)layer));
        rootPane.setLayout(new LayerLayout(rootPane.getLayout(), component));
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.parentLayout != null) {
            this.parentLayout.layoutContainer(parent);
        }
        Rectangle b = parent.getBounds();
        if (this.backPane != null) {
            this.backPane.setBounds(0, 0, b.width, b.height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        if (this.parentLayout == null) {
            return this.backPane.getMinimumSize();
        }
        return this.parentLayout.minimumLayoutSize(c);
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        if (this.parentLayout == null) {
            return this.backPane.getPreferredSize();
        }
        return this.parentLayout.preferredLayoutSize(c);
    }

    @Override
    public void removeLayoutComponent(Component c) {
        if (this.parentLayout != null) {
            this.parentLayout.removeLayoutComponent(c);
        }
    }
}

