/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp3;

import com.spacekiller.util.sound.AudioFileReaderWrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class Mp3AudioFileReader
extends AudioFileReaderWrapper {
    private static final String READER_CLASS = "javazoom.spi.mpeg.sampled.file.MpegAudioFileReader";
    private static final Logger logger = Logger.getLogger(Mp3AudioFileReader.class.getName());

    public Mp3AudioFileReader() {
        try {
            Class<?> clazz = Class.forName(READER_CLASS);
            AudioFileReader r = (AudioFileReader)clazz.newInstance();
            this.setReader(r);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        this.checkMp3URL(url);
        return super.getAudioFileFormat(url);
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        this.checkMp3File(file);
        return super.getAudioFileFormat(file);
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        this.checkMp3Stream(stream);
        return super.getAudioFileFormat(stream);
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.checkMp3URL(url);
        return super.getAudioInputStream(url);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.checkMp3File(file);
        return super.getAudioInputStream(file);
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        this.checkMp3Stream(stream);
        AudioFileReader r = this.getReader();
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        return r.getAudioInputStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMp3File(File file) throws IOException, UnsupportedAudioFileException {
        FileInputStream in = new FileInputStream(file);
        try {
            BufferedInputStream bis = new BufferedInputStream(in);
            try {
                this.checkMp3Stream(bis);
            }
            finally {
                bis.close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMp3URL(URL url) throws IOException, UnsupportedAudioFileException {
        InputStream in = url.openStream();
        try {
            BufferedInputStream bis = new BufferedInputStream(in);
            try {
                this.checkMp3Stream(bis);
            }
            finally {
                bis.close();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMp3Stream(InputStream in) throws IOException, UnsupportedAudioFileException {
        in.mark(1024);
        try {
            byte[] head = new byte[10];
            int n = in.read(head);
            if (n == head.length) {
                int head1;
                String tag = this.bytes2String(head, 0, 3);
                if (tag.equals("ID3")) {
                    return;
                }
                int head0 = head[0] & 0xFF;
                if (head0 == 255 && (head1 = head[1] & 0xFF) >> 5 == 7) {
                    return;
                }
            }
        }
        finally {
            in.reset();
        }
        throw new UnsupportedAudioFileException("Invalid mp3 file header");
    }

    private String bytes2String(byte[] data, int off, int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(data[off + i] & 0xFF);
        }
        return new String(chars);
    }
}

