/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp3;

import com.spacekiller.util.sound.FormatConversionProviderWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public class Mp3FormatConversionProvider
extends FormatConversionProviderWrapper {
    private static final String CONVERTER_CLASS = "javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider";
    private static final Logger logger = Logger.getLogger(Mp3FormatConversionProvider.class.getName());

    public Mp3FormatConversionProvider() {
        try {
            Class<?> clazz = Class.forName(CONVERTER_CLASS);
            FormatConversionProvider c = (FormatConversionProvider)clazz.newInstance();
            this.setCodec(c);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public AudioFormat.Encoding[] getSourceEncodings() {
        return super.getSourceEncodings();
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        return super.getTargetEncodings();
    }

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        return super.isSourceEncodingSupported(sourceEncoding);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        return super.isTargetEncodingSupported(targetEncoding);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        return super.getTargetEncodings(sourceFormat);
    }

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return super.isConversionSupported(targetEncoding, sourceFormat);
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return super.getTargetFormats(targetEncoding, sourceFormat);
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        float sourceRate;
        if (targetFormat == null || sourceFormat == null) {
            return false;
        }
        float targetRate = targetFormat.getSampleRate();
        if (targetRate != (sourceRate = sourceFormat.getSampleRate()) && targetRate > 0.0f) {
            return false;
        }
        return super.isConversionSupported(targetFormat, sourceFormat);
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        return super.getAudioInputStream(targetEncoding, sourceStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        return super.getAudioInputStream(targetFormat, sourceStream);
    }
}

