/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp3;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.mp3.Mp3Id3;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Mp3Id3v2
implements Mp3Id3 {
    private static final int MAX_FRAME_SIZE = 1000000;
    private List frames = new ArrayList();

    @Override
    public void read(DataInput input) throws IOException {
        try {
            byte[] head = new byte[10];
            while (true) {
                input.readFully(head, 0, 10);
                String frameId = new String(head, 0, 4);
                int frameSize = Data.getInt((byte[])head, (int)4);
                if (frameSize >= 1) {
                    if (frameSize < 1000000) {
                        byte[] data = new byte[frameSize];
                        input.readFully(data, 0, frameSize);
                        this.frames.add(new Frame(frameId, data));
                        continue;
                    }
                    input.skipBytes(frameSize);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public int getFrameCount() {
        return this.frames.size();
    }

    @Override
    public String getFrameId(int index) {
        Frame frame = (Frame)this.frames.get(index);
        return frame == null ? null : frame.id;
    }

    @Override
    public byte[] getFrameData(int index) {
        Frame frame = (Frame)this.frames.get(index);
        return frame == null ? null : frame.data;
    }

    @Override
    public String getString(String key) {
        int count = this.getFrameCount();
        for (int i = 0; i < count; ++i) {
            byte[] data;
            String text;
            if (!key.equals(this.getFrameId(i)) || (text = this.parseString(data = this.getFrameData(i))) == null) continue;
            return text;
        }
        return null;
    }

    @Override
    public String parseString(byte[] data) {
        if (data.length < 2) {
            return null;
        }
        byte enc = data[0];
        if (enc == 0) {
            byte[] arr = new byte[data.length - 1];
            System.arraycopy(data, 1, arr, 0, arr.length);
            try {
                return new String(arr, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                return new String(arr);
            }
        }
        if (enc == 1) {
            int p;
            int numChars;
            int x = 1;
            boolean bigEndian = true;
            int bom0 = data[x++] & 0xFF;
            int bom1 = data[x++] & 0xFF;
            if (bom0 == 255 && bom1 == 254) {
                bigEndian = true;
            }
            if (bom0 == 254 && bom1 == 255) {
                bigEndian = false;
            }
            if ((numChars = (data.length - x) / 2) < 1) {
                return "";
            }
            char[] chars = new char[numChars];
            if (bigEndian) {
                for (p = 0; p < numChars; ++p) {
                    chars[p] = (char)((data[x] & 0xFF) + ((data[x + 1] & 0xFF) << 8));
                    x += 2;
                }
            } else {
                for (p = 0; p < numChars; ++p) {
                    chars[p] = (char)((data[x + 1] & 0xFF) + ((data[x] & 0xFF) << 8));
                    x += 2;
                }
            }
            String s = chars[numChars - 1] == '\u0000' ? new String(chars, 0, numChars - 1) : new String(chars);
            return s;
        }
        if (enc == 2) {
            // empty if block
        }
        if (enc == 3) {
            byte[] arr = new byte[data.length - 1];
            System.arraycopy(data, 1, arr, 0, arr.length);
            try {
                return new String(arr, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(arr);
            }
        }
        return "<" + enc + ">" + new String(data);
    }

    protected static class Frame {
        private String id;
        private byte[] data;

        public Frame(String id, byte[] data) {
            this.id = id;
            this.data = data;
        }
    }
}

