/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp3;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.serato.SeratoAutotags;
import com.spacekiller.util.media.library.serato.SeratoMarkers2;
import com.spacekiller.util.media.mp3.Mp3Id3;
import com.spacekiller.util.media.mp3.Mp3Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.HashMap;

public class Mp3MediaScanner
implements MediaScanner {
    public static final String FORMAT_MP3 = "MP3";
    private static final String[] GENRE_V1 = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall"};

    public static String[] getGenreV1Array() {
        String[] arr = new String[GENRE_V1.length];
        System.arraycopy(GENRE_V1, 0, arr, 0, arr.length);
        return arr;
    }

    public static String parseGenreV1(String s) {
        int x;
        if (s.startsWith("(") && (x = s.indexOf(41)) >= 0) {
            String num = s.substring(1, x).trim();
            try {
                int genreIndex = Integer.parseInt(num);
                if (genreIndex >= 0 && genreIndex < GENRE_V1.length && (s = s.substring(x + 1)).trim().length() < 1) {
                    s = GENRE_V1[genreIndex];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException {
        String genre;
        Mp3Id3 id3;
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        mme.setResource(resource);
        InputStream in = resource.createInputStream();
        try {
            id3 = Mp3Util.getInstance().readMp3Id3(in);
            if (id3 == null) {
                throw new StreamCorruptedException("File does not contain ID3 tags: " + resource);
            }
        }
        finally {
            in.close();
        }
        mme.setFormat(FORMAT_MP3);
        double oldBPM = mae.getBpm();
        mae.setBpmStored(0.0);
        HashMap<String, String> tags = new HashMap<String, String>();
        int n = id3.getFrameCount();
        for (int i = 0; i < n; ++i) {
            String key = id3.getFrameId(i);
            if ("GEOB".equals(key)) {
                byte[] data = id3.getFrameData(i);
                this.parseGEOB(id3, data, (MutableMediaEntry)mme);
                continue;
            }
            String value = id3.getString(key);
            if (value == null) continue;
            value = value.trim();
            tags.put(key, value);
        }
        boolean bpmDetected = false;
        if (mae.getBpm() > 0.0) {
            bpmDetected = true;
        } else {
            mae.setBpmStored(oldBPM);
        }
        Object value = tags.get("TRCK");
        if (value != null) {
            try {
                int albumTrack = Integer.parseInt(String.valueOf(value).trim());
                mme.setAlbumTrack(albumTrack);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String title = null;
        value = tags.get("TIT2");
        if (value != null && title == null) {
            title = String.valueOf(value);
        }
        if ((value = tags.get("TIT1")) != null && title == null) {
            title = String.valueOf(value);
        }
        if (title != null) {
            mme.setTitle(title);
        }
        if ((value = tags.get("TALB")) != null) {
            mme.setAlbum(String.valueOf(value));
        }
        if ((value = tags.get("TPE1")) != null) {
            mme.setArtist(String.valueOf(value));
        }
        if ((value = tags.get("TPE2")) != null) {
            mme.setAlbumArtist(String.valueOf(value));
        }
        if ((value = tags.get("TYER")) != null) {
            mme.setYear(String.valueOf(value));
        }
        if ((value = tags.get("TBPM")) != null && !bpmDetected) {
            try {
                double bpm = Double.parseDouble(String.valueOf(value).trim());
                if (bpm > 0.0) {
                    mae.setBpmStored(bpm);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = tags.get("TKEY")) != null) {
            // empty if block
        }
        if ((value = tags.get("TCON")) != null && (genre = Mp3MediaScanner.parseGenreV1(String.valueOf(value))) != null) {
            mme.setGenre(genre);
        }
        return mme;
    }

    protected void parseGEOB(Mp3Id3 id3, byte[] data, MutableMediaEntry entry) {
        String s = id3.parseString(data);
        int x = s.indexOf("Serato Autotags");
        if (x >= 0) {
            try {
                AudioEntry ae;
                byte[] autoTagsData = new byte[data.length - (x += "Serato Autotags".length() + 1)];
                System.arraycopy(data, x, autoTagsData, 0, autoTagsData.length);
                double bpm = SeratoAutotags.parseSeratoBPM((byte[])autoTagsData);
                if (!Double.isNaN(bpm) && (ae = entry.getAudioEntry()) != null && ae instanceof MutableAudioEntry) {
                    MutableAudioEntry mae = (MutableAudioEntry)ae;
                    mae.setBpmStored(bpm);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        x = s.indexOf("Serato Markers2");
        if (x >= 0) {
            try {
                byte[] base64Input = new byte[data.length - (x += "Serato Markers2".length() + 1)];
                System.arraycopy(data, x, base64Input, 0, base64Input.length);
                MediaMarker[] seratoMarkers = SeratoMarkers2.parseSeratoMarkers((byte[])base64Input);
                SeratoMarkers2.updateMediaEntrySeratoMarkers((MutableMediaEntry)entry, (MediaMarker[])seratoMarkers);
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
    }
}

