/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp3;

import com.spacekiller.util.media.mp3.Mp3Id3;
import com.spacekiller.util.media.mp3.Mp3Id3v2;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mp3Util {
    private static final Logger logger = Logger.getLogger(Mp3Util.class.getName());
    private static Mp3Util instance = null;

    private Mp3Util() {
    }

    public static Mp3Util getInstance() {
        if (instance == null) {
            instance = new Mp3Util();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mp3Id3 readMp3Id3(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Mp3Id3 mp3Id3 = this.readMp3Id3(in);
            return mp3Id3;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mp3Id3 readMp3Id3(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            Mp3Id3 mp3Id3 = this.readMp3Id3(in);
            return mp3Id3;
        }
        finally {
            in.close();
        }
    }

    public Mp3Id3 readMp3Id3(InputStream input) throws IOException {
        DataInputStream in = new DataInputStream(input);
        try {
            byte[] buf = new byte[10];
            in.readFully(buf, 0, 3);
            if ("ID3".equals(new String(buf, 0, 3))) {
                byte majorVersion = in.readByte();
                byte minorVersion = in.readByte();
                int flags = in.readByte() & 0xFF;
                int tagSize = this.readTagSize(in);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ID3 version: " + majorVersion + "." + minorVersion + ", flags=" + flags + ", tagSize=" + tagSize);
                }
                if (in.skip(tagSize) != (long)tagSize) {
                    return null;
                }
                Mp3Id3v2 id3 = new Mp3Id3v2();
                id3.read(in);
                return id3;
            }
            return null;
        }
        catch (EOFException e) {
            return null;
        }
    }

    private int readTagSize(InputStream in) throws IOException {
        long value = 0L;
        for (int i = 0; i < 4; ++i) {
            value <<= 7 + in.read();
        }
        return (int)value;
    }
}

