/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mod;

import com.spacekiller.util.Platform;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.mod.ModUtil;
import com.spacekiller.util.thread.DefaultThreadPool;
import com.spacekiller.util.thread.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class ModAudioFileReader
extends AudioFileReader {
    private static final Logger logger = Logger.getLogger(ModAudioFileReader.class.getName());
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int DEFAULT_THREAD_PRIO = 4;
    private int bufferSize = 65536;
    private ThreadPool threadPool;

    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        return ModUtil.getAudioFileFormat(Tools.getFileURL((File)file), this.bufferSize, this.getThreadPool());
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws IOException, UnsupportedAudioFileException {
        return ModUtil.getAudioInputStream(Tools.getFileURL((File)file), this.bufferSize, this.getThreadPool());
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws IOException, UnsupportedAudioFileException {
        return ModUtil.getAudioFileFormat(url, this.bufferSize, this.getThreadPool());
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws IOException, UnsupportedAudioFileException {
        return ModUtil.getAudioInputStream(url, this.bufferSize, this.getThreadPool());
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return ModUtil.getAudioFileFormat(stream, this.bufferSize, this.getThreadPool());
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return ModUtil.getAudioInputStream(stream, this.bufferSize, this.getThreadPool());
    }

    protected ThreadPool createThreadPool() {
        try {
            ThreadManager manager = Platform.getInstance().getThreadManager();
            ClassLoader contextLoader = this.getClass().getClassLoader();
            String namePrefix = "ModAudioFileReader-";
            int priority = 4;
            boolean daemon = true;
            int minThreadCount = 1;
            int maxThreadCount = 100;
            int idleTimeout = 60000;
            return new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getThreadPool() {
        if (this.threadPool == null) {
            ModAudioFileReader modAudioFileReader = this;
            synchronized (modAudioFileReader) {
                if (this.threadPool == null) {
                    this.setThreadPool(this.createThreadPool());
                }
            }
        }
        return this.threadPool;
    }

    protected void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }
}

