/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mod;

import de.quippy.javamod.io.SoundOutputStreamImpl;
import de.quippy.javamod.mixer.Mixer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class ModSoundOutputWrapper
extends SoundOutputStreamImpl
implements Runnable {
    private static final Logger logger = Logger.getLogger(ModSoundOutputWrapper.class.getName());
    private final Mixer mixer;
    private AudioFormat audioFormat;
    private byte[] buf;
    private int max;
    private int size;
    private int head;
    private int tail;
    private boolean eof;
    private volatile boolean cancel;

    public ModSoundOutputWrapper(Mixer mixer, int bufSize) {
        this.mixer = mixer;
        this.max = bufSize;
        this.buf = new byte[this.max];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final AudioFormat getModAudioFormat() {
        AudioFormat format = this.audioFormat;
        if (format != null) {
            return format;
        }
        while (true) {
            byte[] byArray = this.buf;
            // MONITORENTER : this.buf
            format = this.audioFormat;
            if (format != null) {
                // MONITOREXIT : byArray
                return format;
            }
            if (this.eof) {
                throw new RuntimeException("Failed to get audio format!");
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("getModAudioFormat: wait...");
            }
            try {
                this.buf.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("getModAudioFormat: resume...");
            }
            // MONITOREXIT : byArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeAudioFormatTo(AudioFormat format) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("changeAudioFormatTo: " + this + " => " + format);
        }
        this.audioFormat = format;
        super.changeAudioFormatTo(format);
        byte[] byArray = this.buf;
        synchronized (this.buf) {
            this.buf.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void close() {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void writeSampleData(byte[] arr, int off, int len) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("writeSampleData: " + this + ", len=" + len);
        }
        while (len > 0) {
            byte[] byArray = this.buf;
            // MONITORENTER : this.buf
            if (this.cancel) {
                this.eof = true;
                throw new RuntimeException("Mod-Stream cancelled!");
            }
            if (this.size < this.max) {
                int n;
                if (this.head > this.tail) {
                    n = this.head - this.tail;
                    if (n >= len) {
                        System.arraycopy(arr, off, this.buf, this.tail, len);
                        this.tail += len;
                        this.size += len;
                        this.buf.notify();
                        // MONITOREXIT : byArray
                        return;
                    }
                    System.arraycopy(arr, off, this.buf, this.tail, n);
                    this.tail += n;
                    this.size += n;
                    off += n;
                    len -= n;
                    this.buf.notify();
                    // MONITOREXIT : byArray
                    continue;
                }
                n = this.max - this.tail;
                if (n >= len) {
                    System.arraycopy(arr, off, this.buf, this.tail, len);
                    this.tail = (this.tail + len) % this.max;
                    this.size += len;
                    this.buf.notify();
                    // MONITOREXIT : byArray
                    return;
                }
                System.arraycopy(arr, off, this.buf, this.tail, n);
                this.tail = 0;
                this.size += n;
                off += n;
                len -= n;
                this.buf.notify();
                // MONITOREXIT : byArray
                continue;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("writeSampleData: wait: head=" + this.head + ", tail=" + this.tail + ", size=" + this.size + ", len=" + len);
            }
            try {
                this.buf.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("writeSampleData: resume...");
            }
            // MONITOREXIT : byArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final int read(byte[] b, int off, int len) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("readSampleData: " + this + ", len=" + len);
        }
        int o = off;
        while (true) {
            int n;
            byte[] byArray = this.buf;
            // MONITORENTER : this.buf
            if (this.size > 0) {
                if (this.head < this.tail) {
                    n = this.tail - this.head;
                    if (n >= len) {
                        System.arraycopy(this.buf, this.head, b, off, len);
                        this.head += len;
                        this.size -= len;
                        this.buf.notify();
                        // MONITOREXIT : byArray
                        return off + len - o;
                    }
                    System.arraycopy(this.buf, this.head, b, off, n);
                    this.head = this.tail;
                    this.size -= n;
                    off += n;
                    len -= n;
                    this.buf.notify();
                    // MONITOREXIT : byArray
                    continue;
                }
                n = this.max - this.head;
                if (n >= len) {
                    System.arraycopy(this.buf, this.head, b, off, len);
                    this.head = (this.head + len) % this.max;
                    this.size -= len;
                    this.buf.notify();
                    // MONITOREXIT : byArray
                    return off + len - o;
                }
                System.arraycopy(this.buf, this.head, b, off, n);
                this.head = 0;
                this.size -= n;
                off += n;
                len -= n;
                this.buf.notify();
                // MONITOREXIT : byArray
                continue;
            }
            if (this.eof) {
                int n2;
                n = off - o;
                if (n > 0) {
                    n2 = n;
                    return n2;
                }
                n2 = -1;
                // MONITOREXIT : byArray
                return n2;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("readSampleData: wait: head=" + this.head + ", tail=" + this.tail + ", size=" + this.size + ", len=" + len);
            }
            try {
                this.buf.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("readSampleData: resume...");
            }
            // MONITOREXIT : byArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Start playback: mixer=" + this.mixer);
            }
            this.mixer.startPlayback();
        }
        finally {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("End playback: mixer=" + this.mixer);
            }
            byte[] byArray = this.buf;
            synchronized (this.buf) {
                this.eof = true;
                this.buf.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Stopping playback: mixer=" + this.mixer);
        }
        byte[] byArray = this.buf;
        synchronized (this.buf) {
            this.cancel = true;
            this.buf.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.mixer.stopPlayback();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Stopped playback: mixer=" + this.mixer);
            }
            return;
        }
    }
}

