/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mod;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.RandomAccessFileInputStream;
import com.spacekiller.util.media.mod.ModAudioFileFormat;
import com.spacekiller.util.media.mod.ModSoundInputStream;
import com.spacekiller.util.media.mod.ModSoundOutputWrapper;
import com.spacekiller.util.media.mod.ModURLInputStream;
import com.spacekiller.util.media.mod.ModURLStreamHandler;
import com.spacekiller.util.thread.ThreadPool;
import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.main.JavaModMainBase;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModContainer;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.sid.SIDContainer;
import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ModUtil {
    private static final Logger logger = Logger.getLogger(ModUtil.class.getName());
    private static final String FORMAT_MOD = "MOD";
    private static final String FORMAT_SID = "SID";
    private static final String CODEC_JAVAMOD_PREFIX = "JavaMod-";
    private static final int MOD_READ_LIMIT = 32768;
    private static boolean initialized = false;

    private ModUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initJavaMod() {
        if (initialized) {
            return;
        }
        Class<ModUtil> clazz = ModUtil.class;
        synchronized (ModUtil.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                ModUtil.initJavaModImpl();
            }
            finally {
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static void initJavaModImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("init JavaMod...");
        }
        try {
            Properties props = new Properties();
            props.setProperty("javamod.player.megabass", "TRUE");
            props.setProperty("javamod.player.noloops", "1");
            new JavaModMainBase(true);
            MultimediaContainerManager.configureContainer((Properties)props);
            Helpers.setCoding((boolean)true);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JavaMod initialized.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            try {
                String[] supportedExtensions = MultimediaContainerManager.getSupportedFileExtensions();
                logger.fine("Supported extensions: " + supportedExtensions.length);
                if (logger.isLoggable(Level.FINER)) {
                    for (int i = 0; i < supportedExtensions.length; ++i) {
                        logger.finer(" - " + supportedExtensions[i]);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static boolean isMediaResourceSupported(String lowerName) {
        if (lowerName.endsWith(".mod")) {
            return true;
        }
        if (lowerName.endsWith(".xm")) {
            return true;
        }
        return lowerName.endsWith(".sid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException, UnsupportedAudioFileException {
        URL url = resource.getURL();
        String lowerPath = url.toString().toLowerCase();
        if (!ModUtil.isMediaResourceSupported(lowerPath)) {
            return null;
        }
        ModUtil.initJavaMod();
        String title = null;
        String format = null;
        String codec = null;
        double bpm = 0.0;
        int flags = 0;
        if (me != null) {
            flags = me.getFlags();
        }
        if (lowerPath.endsWith(".mod") || lowerPath.endsWith(".xm")) {
            ModfileInputStream mis = new ModfileInputStream(url);
            try {
                Module module = ModuleFactory.getInstance((URL)url);
                if (module != null && module.checkLoadingPossible(mis)) {
                    Module mod = module.loadModFile(mis);
                    format = FORMAT_MOD;
                    String trackerName = mod.getTrackerName();
                    if (trackerName != null && trackerName.length() > 0) {
                        codec = CODEC_JAVAMOD_PREFIX + trackerName;
                    }
                    title = mod.getSongName();
                    int bpmSpeed = mod.getBPMSpeed();
                    if (bpmSpeed > 0) {
                        bpm = bpmSpeed;
                    }
                }
            }
            finally {
                mis.close();
            }
        }
        if (format == null) {
            MultimediaContainer mc;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Create MultimediaContainer: " + url);
            }
            if ((mc = MultimediaContainerManager.getMultimediaContainer((URL)url)) == null) {
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MultimediaContainer: " + mc);
            }
            title = mc.getSongName();
            if (mc instanceof ModContainer) {
                ModContainer mod = (ModContainer)mc;
                format = FORMAT_MOD;
            }
            if (mc instanceof SIDContainer) {
                SIDContainer sid = (SIDContainer)mc;
                format = FORMAT_SID;
                flags |= 2;
            }
            if (format == null && (format = mc.getName()) == null) {
                format = FORMAT_MOD;
            }
        }
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        if (title != null && title.trim().length() > 0) {
            mme.setTitle(title);
        }
        if (codec != null) {
            mae.setAudioCodec(codec);
        }
        if (bpm > 0.0) {
            mae.setBpmStored(bpm);
        }
        mme.setFlags(flags);
        mme.setResource(resource);
        mme.setFormat(format);
        return mme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(URL url, int bufSize, ThreadPool threadPool) throws IOException, UnsupportedAudioFileException {
        AudioInputStream ais = ModUtil.getAudioInputStream(url, bufSize, threadPool);
        try {
            AudioFormat audioFormat = ais.getFormat();
            int frames = -1;
            ModAudioFileFormat modAudioFileFormat = new ModAudioFileFormat(ModAudioFileFormat.MOD_FILE_TYPE, audioFormat, frames);
            return modAudioFileFormat;
        }
        finally {
            ais.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(InputStream stream, int bufSize, ThreadPool threadPool) throws IOException, UnsupportedAudioFileException {
        AudioInputStream ais = ModUtil.getAudioInputStream(stream, bufSize, threadPool);
        try {
            AudioFormat audioFormat = ais.getFormat();
            int frames = -1;
            ModAudioFileFormat modAudioFileFormat = new ModAudioFileFormat(ModAudioFileFormat.MOD_FILE_TYPE, audioFormat, frames);
            return modAudioFileFormat;
        }
        finally {
            ais.close();
        }
    }

    public static AudioInputStream getAudioInputStream(URL url, int bufSize, ThreadPool threadPool) throws IOException, UnsupportedAudioFileException {
        if (!ModUtil.isMediaResourceSupported(url.toString().toLowerCase())) {
            throw new UnsupportedAudioFileException("No module file extension: " + url);
        }
        ModUtil.initJavaMod();
        MultimediaContainer mc = MultimediaContainerManager.getMultimediaContainer((URL)url);
        if (mc == null) {
            throw new UnsupportedAudioFileException("No module file: " + url);
        }
        Mixer mixer = mc.createNewMixer();
        ModSoundOutputWrapper modOut = new ModSoundOutputWrapper(mixer, bufSize);
        mixer.setKeepSilent(true);
        mixer.setSoundOutputStream((SoundOutputStream)modOut);
        try {
            threadPool.start((Runnable)modOut);
        }
        catch (InterruptedException e) {
            throw new UnsupportedAudioFileException("Failed to start worker thread: " + e);
        }
        AudioFormat format = modOut.getModAudioFormat();
        ModSoundInputStream stream = new ModSoundInputStream(modOut);
        long length = -1L;
        AudioInputStream ais = new AudioInputStream(stream, format, length);
        return ais;
    }

    public static AudioInputStream getAudioInputStream(InputStream stream, int bufSize, ThreadPool threadPool) throws IOException, UnsupportedAudioFileException {
        RandomAccessFileInputStream rafis;
        File file;
        String fileName = null;
        if (stream instanceof RandomAccessFileInputStream && (file = (rafis = (RandomAccessFileInputStream)stream).getFile()) != null && !ModUtil.isMediaResourceSupported((fileName = file.getName()).toLowerCase())) {
            throw new UnsupportedAudioFileException("No module file extension: " + fileName);
        }
        if (fileName == null) {
            fileName = stream.hashCode() + ".mod";
        }
        boolean done = false;
        stream.mark(32768);
        try {
            String spec = "javamod:" + fileName;
            ModURLInputStream modStream = new ModURLInputStream(stream);
            modStream.setAutoClose(false);
            ModURLStreamHandler handler = new ModURLStreamHandler(modStream);
            URL dummyContext = null;
            URL dummyURL = new URL(dummyContext, spec, handler);
            AudioInputStream ais = ModUtil.getAudioInputStream(dummyURL, bufSize, threadPool);
            modStream.setAutoClose(true);
            done = true;
            AudioInputStream audioInputStream = ais;
            return audioInputStream;
        }
        catch (UnsupportedAudioFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedAudioFileException();
        }
        finally {
            if (!done) {
                try {
                    stream.reset();
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
            }
        }
    }
}

