/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.sid;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.mod.ModMediaScanner;

public class SidMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "SID";
    private static final String DEFAULT_FILE_EXTENSION = ".sid";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".sid"};
    private static final String FILE_FORMAT_TITLE = "Commodore C64 Sound Interface Device";
    private SimpleFileFormatSignature sidFileSignature;
    private MediaScanner mediaScanner;

    public SidMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/spacekiller/util/media/sid/icons/sid_format.png"));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.sidFileSignature = new SimpleFileFormatSignature("SID Header", (FileFormat)this, 0, "PSID".getBytes());
        this.setSupportedSignatures(new FileFormatSignature[]{this.sidFileSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            this.mediaScanner = new ModMediaScanner();
        }
        return this.mediaScanner;
    }
}

