/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.picture;

import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.media.picture.PicturePlayer;
import com.spacekiller.util.media.picture.PicturePlayerItem;
import com.spacekiller.util.media.picture.SlideShowControlPanel;
import com.spacekiller.util.media.picture.SlideShowViewerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class PictureMediaPlayerPanel
extends JPanel {
    private static final long serialVersionUID = -2744095387035842238L;
    private static final Logger logger = Logger.getLogger(PictureMediaPlayerPanel.class.getName());
    private PicturePlayer player;
    private SlideShowControlPanel slideShowControlPanel;
    private SlideShowViewerPanel slideShowViewerPanel;

    public PictureMediaPlayerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.slideShowControlPanel = new SlideShowControlPanel();
        GridBagConstraints gbc_slideShowControlPanel = new GridBagConstraints();
        gbc_slideShowControlPanel.weightx = 1.0;
        gbc_slideShowControlPanel.fill = 1;
        gbc_slideShowControlPanel.gridx = 0;
        gbc_slideShowControlPanel.gridy = 0;
        this.add((Component)this.slideShowControlPanel, gbc_slideShowControlPanel);
        this.slideShowViewerPanel = new SlideShowViewerPanel();
        this.slideShowViewerPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_slideShowViewerPanel = new GridBagConstraints();
        gbc_slideShowViewerPanel.weighty = 1.0;
        gbc_slideShowViewerPanel.weightx = 1.0;
        gbc_slideShowViewerPanel.fill = 1;
        gbc_slideShowViewerPanel.gridx = 0;
        gbc_slideShowViewerPanel.gridy = 1;
        this.add((Component)this.slideShowViewerPanel, gbc_slideShowViewerPanel);
        this.initPictureMediaPlayerPanel();
    }

    protected void initPictureMediaPlayerPanel() {
        this.setPreferredSize(new Dimension(500, 400));
    }

    protected SlideShowControlPanel getSlideShowControlPanel() {
        return this.slideShowControlPanel;
    }

    protected SlideShowViewerPanel getSlideShowViewerPanel() {
        return this.slideShowViewerPanel;
    }

    public void setCurrentEntry(MediaCrateEntry entry, MediaPlayerContext context, int index) {
        try {
            PicturePlayer player = this.getPlayer();
            if (player == null) {
                return;
            }
            MediaTableEntry mte = null;
            if (entry != null && entry instanceof MediaTableEntry) {
                mte = (MediaTableEntry)entry;
            }
            int tableRow = index;
            MediaEntry me = context.getMediaEntry(entry);
            BufferedImage image = null;
            PicturePlayerItem item = new PicturePlayerItem(mte, tableRow, me, image);
            player.play((PlayerItem)item);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected PicturePlayer createPlayer() {
        return new PicturePlayer(this.getSlideShowViewerPanel());
    }

    public PicturePlayer getPlayer() {
        if (this.player == null) {
            this.setPlayer(this.createPlayer());
        }
        return this.player;
    }

    public void setPlayer(PicturePlayer player) {
        this.player = player;
    }
}

