/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.picture;

import com.spacekiller.util.FileType;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.media.picture.PictureMediaFileFormat;
import com.spacekiller.util.media.picture.PictureMediaFileType;
import com.spacekiller.util.media.picture.PictureMediaPlayerView;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.View;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.Icon;

public class PictureMediaPlayerViewProvider
extends DefaultViewProvider {
    private static final Logger logger = Logger.getLogger(PictureMediaPlayerViewProvider.class.getName());

    public PictureMediaPlayerViewProvider() {
        this.initPictureMediaPlayerViewProvider();
    }

    protected void initPictureMediaPlayerViewProvider() {
        try {
            HashSet<String> doneExtensions = new HashSet<String>();
            String[] imageFormatNames = ImageIO.getReaderFormatNames();
            int num = imageFormatNames == null ? 0 : imageFormatNames.length;
            for (int i = 0; i < num; ++i) {
                Iterator<ImageReader> iter;
                String formatName = imageFormatNames[i];
                if (formatName == null || (iter = ImageIO.getImageReadersByFormatName(formatName)) == null) continue;
                while (iter.hasNext()) {
                    String defaultExtension;
                    ImageReader imageReader = iter.next();
                    if (imageReader == null || !doneExtensions.add(defaultExtension = "." + formatName.toLowerCase())) continue;
                    String[] extensions = new String[]{defaultExtension};
                    formatName = formatName.toUpperCase();
                    String title = formatName + " File";
                    Icon icon = null;
                    FileFormatSignature[] signatures = null;
                    PictureMediaFileFormat fileFormat = new PictureMediaFileFormat(formatName, title, icon, defaultExtension, extensions, signatures);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("PictureMediaFileFormat: " + formatName + " => " + (Object)((Object)fileFormat));
                    }
                    PictureMediaFileType fileType = new PictureMediaFileType((FileFormat)fileFormat);
                    Platform.getInstance().getFileTypeRegistry().registerFileType((FileType)fileType);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void initView(View v) {
        block0: {
            super.initView(v);
            if (!(v instanceof PictureMediaPlayerView)) break block0;
            PictureMediaPlayerView mmv = (PictureMediaPlayerView)v;
        }
    }

    public View loadView(Preferences prefs) throws Exception {
        return super.loadView(prefs);
    }

    protected void loadView(View view, Preferences prefs) throws Exception {
        super.loadView(view, prefs);
        if (view != null && view instanceof PictureMediaPlayerView) {
            PictureMediaPlayerView pictureMediaPlayerView = (PictureMediaPlayerView)view;
        }
    }

    public void saveView(View view, Preferences prefs) throws Exception {
        super.saveView(view, prefs);
        if (view != null && view instanceof PictureMediaPlayerView) {
            PictureMediaPlayerView pictureMediaPlayerView = (PictureMediaPlayerView)view;
        }
    }
}

