/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.picture;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.manager.PictureUtil;
import com.spacekiller.util.media.picture.PicturePlayerItem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SlideShowViewerPanel
extends JPanel {
    private static final long serialVersionUID = 8278128685370636108L;
    private static final Logger logger = Logger.getLogger(SlideShowViewerPanel.class.getName());
    public static final int DEFAULT_TRANSITION_MILLIS = 1000;
    public static final int DEFAULT_TIMER_DELAY = 40;
    private BufferedImage bufferedImage;
    private PicturePlayerItem currentItem;
    private boolean proportial = true;
    private Timer timer = new Timer(this.timerDelay, new TimerHandler());
    private int timerDelay = 40;
    private int transitionMillis = 1000;
    private PicturePlayerItem oldItem;
    private PicturePlayerItem newItem;
    private float transition;
    private long transitionStart;

    public SlideShowViewerPanel() {
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.timer.setInitialDelay(0);
        this.timer.setDelay(this.timerDelay);
        this.prepareBuffer();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage bi = this.bufferedImage;
        if (bi != null) {
            this.applyRenderingHints((Graphics2D)g);
            g.drawImage(bi, 0, 0, null);
        }
    }

    protected void applyRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.prepareBuffer();
    }

    protected synchronized void prepareBuffer() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        BufferedImage bi = new BufferedImage(width, height, 1);
        this.paintBuffer(bi);
        BufferedImage old = this.bufferedImage;
        this.bufferedImage = bi;
        if (old != null) {
            old.flush();
        }
    }

    protected void paintBuffer(BufferedImage bi) {
        float alpha;
        BufferedImage img2;
        PicturePlayerItem item2;
        float alpha2;
        BufferedImage img1;
        int width = bi.getWidth();
        int height = bi.getHeight();
        Graphics2D g = (Graphics2D)bi.getGraphics();
        Color bgcolor = Color.BLACK;
        g.setColor(bgcolor);
        g.fillRect(0, 0, width, height);
        this.applyRenderingHints(g);
        float transition = this.transition;
        PicturePlayerItem item1 = this.oldItem;
        if (item1 != null && (img1 = item1.getBufferedImage()) != null && (alpha2 = 1.0f - transition) > 0.0f) {
            g.setComposite(AlphaComposite.getInstance(3, alpha2));
            PictureUtil.drawImage((Image)img1, (ImageObserver)this, (Graphics2D)g, (int)width, (int)height, (Color)bgcolor, (boolean)this.proportial);
        }
        if ((item2 = this.newItem) != null && (img2 = item2.getBufferedImage()) != null && (alpha = transition) > 0.0f) {
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            PictureUtil.drawImage((Image)img2, (ImageObserver)this, (Graphics2D)g, (int)width, (int)height, (Color)bgcolor, (boolean)this.proportial);
        }
        g.dispose();
    }

    public PicturePlayerItem getCurrentItem() {
        return this.currentItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentItem(PicturePlayerItem currentItem) {
        BufferedImage image;
        BufferedImage bufferedImage = image = currentItem == null ? null : currentItem.getBufferedImage();
        if (image == null && currentItem != null) {
            try {
                Resource resource = currentItem.getResource();
                InputStream stream = resource.createInputStream();
                try {
                    image = PictureUtil.createBufferedImage((InputStream)stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        SlideShowViewerPanel slideShowViewerPanel = this;
        synchronized (slideShowViewerPanel) {
            if (currentItem != null && image != null) {
                currentItem.setBufferedImage(image);
            }
            this.currentItem = currentItem;
            if (this.newItem == null) {
                this.newItem = currentItem;
            }
            this.timer.start();
        }
    }

    public boolean isProportial() {
        return this.proportial;
    }

    public void setProportial(boolean proportial) {
        this.proportial = proportial;
    }

    public int getTransitionMillis() {
        return this.transitionMillis;
    }

    public void setTransitionMillis(int transitionMillis) {
        this.transitionMillis = transitionMillis;
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int timerDelay) {
        this.timerDelay = timerDelay;
        this.timer.setDelay(timerDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void perform() {
        float trans;
        long elapsed;
        long time = System.currentTimeMillis();
        if (this.transitionStart == 0L) {
            this.transitionStart = time;
        }
        if ((elapsed = time - this.transitionStart) <= 0L) {
            trans = 0.0f;
        } else {
            trans = (float)elapsed / (float)this.transitionMillis;
            if (trans >= 1.0f) {
                trans = 1.0f;
                Image oldImage = null;
                try {
                    SlideShowViewerPanel slideShowViewerPanel = this;
                    synchronized (slideShowViewerPanel) {
                        PicturePlayerItem old = this.oldItem;
                        if (old != null && old != this.newItem) {
                            oldImage = old.getBufferedImage();
                        }
                        this.oldItem = this.newItem;
                        this.transitionStart = 0L;
                        trans = 0.0f;
                        if (this.currentItem != null && this.currentItem != this.newItem) {
                            this.newItem = this.currentItem;
                        } else {
                            this.newItem = null;
                            this.timer.stop();
                            logger.info("Transition completed.");
                        }
                    }
                }
                finally {
                    if (oldImage != null) {
                        oldImage.flush();
                    }
                }
            }
        }
        this.transition = trans;
        this.paintBuffer(this.bufferedImage);
        this.repaint();
    }

    protected class TimerHandler
    implements ActionListener {
        protected TimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SlideShowViewerPanel.this.perform();
        }
    }
}

