/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.waxlab.Line;

public class LineMidiMapping
extends MidiMapping {
    private static final String ACTION_SEPARATOR = ".";
    private final Line line;

    public LineMidiMapping(int channel, int command, int index, String action, Line line) {
        super(channel, command, index, action);
        this.line = line;
    }

    public final Line getLine() {
        return this.line;
    }

    public static LineMidiMapping getLineMidiMapping(Line line, MidiMapping mapping) {
        int index;
        int command;
        int channel;
        String action;
        String oldAction;
        String string = oldAction = mapping == null ? null : mapping.getAction();
        if (mapping != null && mapping instanceof LineMidiMapping) {
            LineMidiMapping lineMapping = (LineMidiMapping)mapping;
            action = LineMidiMapping.formatLineAction(line, LineMidiMapping.parseLineAction(oldAction));
            if (line == lineMapping.getLine() && action.equals(oldAction)) {
                return lineMapping;
            }
        } else {
            action = LineMidiMapping.formatLineAction(line, LineMidiMapping.parseLineAction(oldAction));
        }
        if (mapping != null) {
            channel = mapping.getChannel();
            command = mapping.getCommand();
            index = mapping.getIndex();
        } else {
            channel = -1;
            command = -1;
            index = -1;
        }
        return new LineMidiMapping(channel, command, index, action, line);
    }

    public static String parseLineName(String action) {
        if (action == null) {
            return null;
        }
        int x = action.lastIndexOf(ACTION_SEPARATOR);
        if (x < 0) {
            return null;
        }
        return action.substring(0, x);
    }

    public static String parseLineAction(String action) {
        if (action == null) {
            return null;
        }
        int x = action.lastIndexOf(ACTION_SEPARATOR);
        if (x < 0) {
            return action;
        }
        return action.substring(x + ACTION_SEPARATOR.length());
    }

    public static String formatLineAction(Line line, String lineAction) {
        String prefix = line == null ? null : line.getName();
        prefix = prefix == null ? "" : prefix + ACTION_SEPARATOR;
        return prefix + lineAction;
    }
}

