/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab;

import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.waxlab.Line;

public class LineMidiTrigger
extends MidiTrigger {
    private static final String EVENT_SEPARATOR = ".";
    private final Line line;

    public LineMidiTrigger(String event, int channel, int command, int index, int value, Line line) {
        super(event, channel, command, index, value);
        this.line = line;
    }

    public final Line getLine() {
        return this.line;
    }

    public static LineMidiTrigger getLineMidiTrigger(Line line, MidiTrigger trigger) {
        int value;
        int index;
        int command;
        int channel;
        String event;
        String oldEvent;
        String string = oldEvent = trigger == null ? null : trigger.getEvent();
        if (trigger != null && trigger instanceof LineMidiTrigger) {
            LineMidiTrigger lineTrigger = (LineMidiTrigger)trigger;
            event = LineMidiTrigger.formatLineEvent(line, LineMidiTrigger.parseLineEvent(oldEvent));
            if (line == lineTrigger.getLine() && event.equals(oldEvent)) {
                return lineTrigger;
            }
        } else {
            event = LineMidiTrigger.formatLineEvent(line, LineMidiTrigger.parseLineEvent(oldEvent));
        }
        if (trigger != null) {
            channel = trigger.getChannel();
            command = trigger.getCommand();
            index = trigger.getIndex();
            value = trigger.getValue();
        } else {
            channel = -1;
            command = -1;
            index = -1;
            value = -1;
        }
        return new LineMidiTrigger(event, channel, command, index, value, line);
    }

    public static String parseLineName(String action) {
        if (action == null) {
            return null;
        }
        int x = action.lastIndexOf(EVENT_SEPARATOR);
        if (x < 0) {
            return null;
        }
        return action.substring(0, x);
    }

    public static String parseLineEvent(String action) {
        if (action == null) {
            return null;
        }
        int x = action.lastIndexOf(EVENT_SEPARATOR);
        if (x < 0) {
            return action;
        }
        return action.substring(x + EVENT_SEPARATOR.length());
    }

    public static String formatLineEvent(Line line, String lineAction) {
        String prefix = line == null ? null : line.getName();
        prefix = prefix == null ? "" : prefix + EVENT_SEPARATOR;
        return prefix + lineAction;
    }
}

