/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab;

import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.impl.FaderCurveUtil;
import com.waxmonster.fader.midi.DefaultMidiFaderConfig;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.ScratchLineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import java.io.Serializable;

public class TimecodeLineConfig
extends ScratchLineConfig
implements Serializable {
    private static final long serialVersionUID = -5579788757173897774L;
    private String name;
    private boolean recordingEnabled;
    private WaxLabPortInfo[] recordingPorts;
    private WaxLabPortInfo[] liveFeedPorts;
    private WaxLabPortInfo timecodeMidiInputPort;
    private MidiLine faderMidiLine;
    private WaxLabPortInfo midiInputPort;
    private WaxLabPortInfo midiOutputPort;
    private String timecodeFormatName;
    private boolean playbackEnabled;
    private boolean scratchingEnabled;
    private boolean preFaderEnabled;
    private double preFaderVolume = 1.0;
    private WaxLabPortInfo[] preFaderPorts;
    private boolean postFaderEnabled;
    private double postFaderVolume = 1.0;
    private WaxLabPortInfo[] postFaderPorts;
    private String scratchMode = "Relative";
    private String pitchMode = "Normal";
    private double pitchBPM;
    private ScratchLine pitchLine;
    private double jumpBeats = 1.0;
    private double sliceBeats = 1.0;
    private boolean audioFaderEnabled;
    private FaderConfig[] audioFaderConfigs;
    private boolean invertedView;
    private boolean faderShadingView = true;
    private boolean scratchPositionViewEnabled = true;
    private boolean beatRadarViewEnabled = true;
    private boolean beatCompassViewEnabled = false;

    @Override
    public LineConfig cloneLineConfig() throws CloneNotSupportedException {
        TimecodeLineConfig clone = (TimecodeLineConfig)this.clone();
        FaderConfig[] faderConfigs = this.getAudioFaderConfigs();
        if (faderConfigs != null) {
            int num = faderConfigs.length;
            FaderConfig[] cloneFaderConfigs = new FaderConfig[num];
            for (int i = 0; i < num; ++i) {
                FaderConfig faderConfig = faderConfigs[i];
                if (faderConfig == null) continue;
                cloneFaderConfigs[i] = faderConfig.cloneFaderConfig();
            }
            clone.audioFaderConfigs = cloneFaderConfigs;
        }
        return clone;
    }

    public String getTimecodeFormatName() {
        return this.timecodeFormatName;
    }

    public void setTimecodeFormatName(String timecodeFormatName) {
        this.timecodeFormatName = timecodeFormatName;
    }

    public boolean isRecordingEnabled() {
        return this.recordingEnabled;
    }

    public void setRecordingEnabled(boolean recordingEnabled) {
        this.recordingEnabled = recordingEnabled;
    }

    public boolean isScratchingEnabled() {
        return this.scratchingEnabled;
    }

    public void setScratchingEnabled(boolean scratcherEnabled) {
        this.scratchingEnabled = scratcherEnabled;
    }

    public boolean isPlaybackEnabled() {
        return this.playbackEnabled;
    }

    public void setPlaybackEnabled(boolean playerEnabled) {
        this.playbackEnabled = playerEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isInvertedView() {
        return this.invertedView;
    }

    public void setInvertedView(boolean invertedView) {
        this.invertedView = invertedView;
    }

    public boolean isFaderShadingView() {
        return this.faderShadingView;
    }

    public void setFaderShadingView(boolean faderShadingView) {
        this.faderShadingView = faderShadingView;
    }

    public String getScratchMode() {
        return this.scratchMode;
    }

    public void setScratchMode(String scratchMode) {
        this.scratchMode = scratchMode;
    }

    public WaxLabPortInfo[] getRecordingPorts() {
        return this.recordingPorts;
    }

    public void setRecordingPorts(WaxLabPortInfo[] recordingPorts) {
        this.recordingPorts = recordingPorts;
    }

    public boolean isPreFaderEnabled() {
        return this.preFaderEnabled;
    }

    public void setPreFaderEnabled(boolean preFaderEnabled) {
        this.preFaderEnabled = preFaderEnabled;
    }

    public boolean isPostFaderEnabled() {
        return this.postFaderEnabled;
    }

    public void setPostFaderEnabled(boolean postFaderEnabled) {
        this.postFaderEnabled = postFaderEnabled;
    }

    public WaxLabPortInfo[] getPreFaderPorts() {
        return this.preFaderPorts;
    }

    public void setPreFaderPorts(WaxLabPortInfo[] preFaderPorts) {
        this.preFaderPorts = preFaderPorts;
    }

    public WaxLabPortInfo[] getPostFaderPorts() {
        return this.postFaderPorts;
    }

    public void setPostFaderPorts(WaxLabPortInfo[] postFaderPorts) {
        this.postFaderPorts = postFaderPorts;
    }

    public double getPreFaderVolume() {
        return this.preFaderVolume;
    }

    public void setPreFaderVolume(double preFaderVolume) {
        this.preFaderVolume = preFaderVolume;
    }

    public double getPostFaderVolume() {
        return this.postFaderVolume;
    }

    public void setPostFaderVolume(double postFaderVolume) {
        this.postFaderVolume = postFaderVolume;
    }

    public WaxLabPortInfo[] getLiveFeedPorts() {
        return this.liveFeedPorts;
    }

    public void setLiveFeedPorts(WaxLabPortInfo[] liveFeedPorts) {
        this.liveFeedPorts = liveFeedPorts;
    }

    public MidiLine getFaderMidiLine() {
        return this.faderMidiLine;
    }

    public void setFaderMidiLine(MidiLine faderMidiLine) {
        this.faderMidiLine = faderMidiLine;
    }

    public WaxLabPortInfo getMidiInputPort() {
        return this.midiInputPort;
    }

    public void setMidiInputPort(WaxLabPortInfo midiInputPort) {
        this.midiInputPort = midiInputPort;
    }

    public WaxLabPortInfo getMidiOutputPort() {
        return this.midiOutputPort;
    }

    public void setMidiOutputPort(WaxLabPortInfo midiOutputPort) {
        this.midiOutputPort = midiOutputPort;
    }

    public double getPitchBPM() {
        return this.pitchBPM;
    }

    public void setPitchBPM(double pitchBPM) {
        this.pitchBPM = pitchBPM;
    }

    public ScratchLine getPitchLine() {
        return this.pitchLine;
    }

    public void setPitchLine(ScratchLine pitchLine) {
        this.pitchLine = pitchLine;
    }

    public String getPitchMode() {
        return this.pitchMode;
    }

    public void setPitchMode(String pitchMode) {
        this.pitchMode = pitchMode;
    }

    public double getJumpBeats() {
        return this.jumpBeats;
    }

    public void setJumpBeats(double jumpBeats) {
        this.jumpBeats = jumpBeats;
    }

    public double getSliceBeats() {
        return this.sliceBeats;
    }

    public void setSliceBeats(double sliceBeats) {
        this.sliceBeats = sliceBeats;
    }

    public boolean isAudioFaderEnabled() {
        return this.audioFaderEnabled;
    }

    public void setAudioFaderEnabled(boolean audioFaderEnabled) {
        this.audioFaderEnabled = audioFaderEnabled;
    }

    public boolean isScratchPositionViewEnabled() {
        return this.scratchPositionViewEnabled;
    }

    public void setScratchPositionViewEnabled(boolean scratchPositionViewEnabled) {
        this.scratchPositionViewEnabled = scratchPositionViewEnabled;
    }

    public boolean isBeatCompassViewEnabled() {
        return this.beatCompassViewEnabled;
    }

    public void setBeatCompassViewEnabled(boolean beatCompassViewEnabled) {
        this.beatCompassViewEnabled = beatCompassViewEnabled;
    }

    public boolean isBeatRadarViewEnabled() {
        return this.beatRadarViewEnabled;
    }

    public void setBeatRadarViewEnabled(boolean beatRadarViewEnabled) {
        this.beatRadarViewEnabled = beatRadarViewEnabled;
    }

    public WaxLabPortInfo getTimecodeMidiInputPort() {
        return this.timecodeMidiInputPort;
    }

    public void setTimecodeMidiInputPort(WaxLabPortInfo timecodeMidiInputPort) {
        this.timecodeMidiInputPort = timecodeMidiInputPort;
    }

    public FaderConfig[] getAudioFaderConfigs() {
        return this.audioFaderConfigs;
    }

    public void setAudioFaderConfigs(FaderConfig[] audioFaderConfigs) {
        this.audioFaderConfigs = audioFaderConfigs;
    }

    public FaderConfig[] createDefaultFaderConfigs(boolean leftDeck) {
        DefaultMidiFaderConfig lineFaderConfig = new DefaultMidiFaderConfig();
        lineFaderConfig.setFaderName("Line-Fader");
        lineFaderConfig.setFaderType(0);
        lineFaderConfig.setInitValue(1.0f);
        lineFaderConfig.setFaderCurve(FaderCurveUtil.createDefaultFaderCurve((String)"Line Fader Curve", (boolean)false));
        int crossFaderType = leftDeck ? 1 : 2;
        DefaultMidiFaderConfig crossFaderConfig = new DefaultMidiFaderConfig();
        crossFaderConfig.setFaderName("Cross-Fader");
        crossFaderConfig.setFaderType(crossFaderType);
        crossFaderConfig.setInitValue(0.5f);
        crossFaderConfig.setFaderCurve(FaderCurveUtil.createDefaultFaderCurve((String)"Cross Fader Curve", (boolean)true));
        DefaultMidiFaderConfig balanceFaderLeftConfig = new DefaultMidiFaderConfig();
        balanceFaderLeftConfig.setFaderName("Balance-Left");
        balanceFaderLeftConfig.setChannelMask(-2);
        balanceFaderLeftConfig.setFaderType(3);
        balanceFaderLeftConfig.setInitValue(0.5f);
        balanceFaderLeftConfig.setFaderCurve(FaderCurveUtil.createDefaultFaderCurve((String)"Balance Left Curve", (boolean)true));
        DefaultMidiFaderConfig balanceFaderRightConfig = new DefaultMidiFaderConfig();
        balanceFaderRightConfig.setFaderName("Balance-Right");
        balanceFaderRightConfig.setChannelMask(-3);
        balanceFaderRightConfig.setFaderType(4);
        balanceFaderRightConfig.setInitValue(0.5f);
        balanceFaderRightConfig.setFaderCurve(FaderCurveUtil.createDefaultFaderCurve((String)"Balance Right Curve", (boolean)true));
        return new FaderConfig[]{lineFaderConfig, crossFaderConfig, balanceFaderLeftConfig, balanceFaderRightConfig};
    }
}

