/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.midi.file.TrackModelFile;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.sound.SoundSystem;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.WaxEditorFile;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MidiTrack;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.impl.CachedFaderModel;
import com.waxmonster.model.impl.CachedMidiModel;
import com.waxmonster.model.impl.CachedTimecodeModel;
import com.waxmonster.model.impl.FaderFile;
import com.waxmonster.model.impl.SeekableAudioModel;
import com.waxmonster.model.impl.TimecodeFile;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.TimecodeManager;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLabListener;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public interface WaxLab {
    public static final String CLOCK_TYPE_AUTOMATIC = "Auto";
    public static final String CLOCK_TYPE_AUDIO_PORT = "AudioPort";
    public static final String CLOCK_TYPE_SYSTEM = "System";
    public static final String MIDI_ACTION_WAXLAB_START = "Start";
    public static final String MIDI_ACTION_WAXLAB_PAUSE = "Pause";
    public static final String MIDI_ACTION_WAXLAB_STOP = "Stop";
    public static final String MIDI_ACTION_WAXLAB_TOGGLE_START_PAUSE = "ToggleStartPause";
    public static final String MIDI_ACTION_WAXLAB_TOGGLE_START_STOP = "ToggleStartStop";
    public static final String MIDI_ACTION_REFRESH_LIGHTING = "RefreshLighting";
    public static final String MIDI_EVENT_WAXLAB_STARTED = "Started";
    public static final String MIDI_EVENT_WAXLAB_STOPPED = "Stopped";

    public String getName();

    public void setName(String var1);

    public String getPlayerNamePrefix();

    public void setPlayerNamePrefix(String var1);

    public int getLineCount();

    public Line getLineAt(int var1);

    public Line[] getLines();

    public int getLineIndex(Line var1);

    public void addLine(Line var1);

    public void insertLineAt(Line var1, int var2);

    public void moveLine(Line var1, int var2);

    public void removeLine(Line var1);

    public void removeLineAt(int var1);

    public void applyLineConfig(Line var1, LineConfig var2) throws IOException;

    public void mediate();

    public boolean isMediatePending();

    public boolean isAutoMediate();

    public void setAutoMediate(boolean var1);

    public void registerWaxLabListener(WaxLabListener var1);

    public void unregisterWaxLabListener(WaxLabListener var1);

    public AudioLine createAudioLine();

    public MidiLine createMidiLine();

    public TimecodeLine createTimecodeLine(boolean var1);

    public EditorLine createEditorLine();

    public TimecodeManager getTimecodeManager();

    public WaxLabPreferences getWaxLabPreferences();

    public void setWaxLabPreferences(WaxLabPreferences var1);

    public File getWaxLabFile();

    public void setWaxLabFile(File var1);

    public File getContentDirectory();

    public void setContentDirectory(File var1);

    public File makeContentDirectory() throws IOException;

    public boolean isAudioFile(File var1) throws IOException;

    public boolean isTimecodeFile(File var1) throws IOException;

    public boolean isMidiFile(File var1) throws IOException;

    public boolean isWaxEditorFile(File var1) throws IOException;

    public CachedMidiModel createCachedMidiModel(TrackModelFile var1, boolean var2) throws IOException;

    public MidiTrack[] createMidiTracks(Resource var1, boolean var2) throws IOException;

    public MidiTrack[] createMidiTracks(Resource var1, String[] var2, boolean var3) throws IOException;

    public MidiModel createMidiModel(MidiTrack[] var1) throws IOException;

    public CachedAudioModel createCachedAudioModel(Resource var1, String[] var2, boolean var3) throws IOException;

    public CachedAudioModel createCachedAudioModel(File var1, String[] var2, boolean var3) throws IOException;

    public CachedAudioModel createCachedAudioModel(AudioFile var1) throws IOException;

    public SeekableAudioModel createSeekableAudioModel(Resource var1, MediaEntry var2, AudioFormat var3) throws IOException, UnsupportedAudioFileException;

    public CachedTimecodeModel analyzeTimecodeAudioModel(File var1, TimecodeLineConfig var2, double[] var3) throws IOException;

    public CachedTimecodeModel analyzeTimecodeAudioModel(CachedAudioModel var1, TimecodeFormat var2, int var3, String var4, double[] var5) throws IOException;

    public CachedTimecodeModel createCachedTimecodeModel(Resource var1, String[] var2, boolean var3) throws IOException;

    public CachedTimecodeModel createCachedTimecodeModel(File var1, String[] var2, boolean var3) throws IOException;

    public CachedTimecodeModel createCachedTimecodeModel(TimecodeFile var1, boolean var2) throws IOException;

    public CachedFaderModel createCachedFaderModel(Resource var1, String[] var2, boolean var3) throws IOException;

    public CachedFaderModel createCachedFaderModel(File var1, String[] var2, boolean var3) throws IOException;

    public CachedFaderModel createCachedFaderModel(FaderFile var1) throws IOException;

    public WaxEditorModel createCachedWaxEditorModel(Resource var1, String[] var2, boolean var3) throws IOException;

    public WaxEditorModel[] createCachedWaxEditorModels(File var1, boolean var2) throws IOException;

    public void saveWaxLabConfig(File var1, boolean var2) throws IOException;

    public void loadWaxLabConfig(File var1, boolean var2) throws IOException;

    public void loadWaxLabConfig(URL var1, boolean var2) throws IOException;

    public InterpolatorRegistry getInterpolatorRegistry();

    public SoundSystem getSoundSystem();

    public boolean isDirty();

    public void setDirtyFlag();

    public void clearDirtyFlag();

    public void writeAudioFile(AudioFile var1, File var2) throws IOException;

    public void writeTimecodeModel(TimecodeModel var1, File var2) throws IOException;

    public void writeFaderModel(FaderModel var1, File var2) throws IOException;

    public void writeWaxEditorModels(WaxEditorModel[] var1, File var2) throws IOException;

    public long exportEditorLineToAudioFile(EditorLine var1, long var2, long var4, int var6, AudioFile var7, long var8) throws IOException;

    public long exportEditorLineToAudioModel(EditorLine var1, long var2, long var4, int var6, SampleModel var7) throws IOException;

    public long exportEditorLineToTimecodeFile(EditorLine var1, long var2, long var4, int var6, TimecodeFile var7, long var8) throws IOException;

    public long exportEditorLineToFaderFile(EditorLine var1, long var2, long var4, int var6, FaderFile var7, long var8) throws IOException;

    public long exportTimecodeLineToTimecodeFile(TimecodeLine var1, long var2, long var4, int var6, TimecodeFile var7, long var8) throws IOException;

    public AudioFile createAudioFile(File var1, AudioFormat var2) throws IOException;

    public AudioFile createNewAudioFile(String var1, AudioFormat var2) throws IOException;

    public FaderFile createNewFaderFile(String var1, float var2) throws IOException;

    public TimecodeFile createNewTimecodeFile(String var1, float var2) throws IOException;

    public WaxEditorFile createNewWaxEditorFile(String var1) throws IOException;

    public TrackModelFile createNewMidiTrackFile(String var1, float var2) throws IOException;

    public TrackModelFile createMidiTrackFile(File var1, boolean var2) throws IOException;

    public TimecodeFormat getTimecodeFormat(String var1) throws IOException;

    public String getClockType();

    public void setClockType(String var1);

    public WaxLabPortInfo getClockAudioPort();

    public void setClockAudioPort(WaxLabPortInfo var1);

    public WaxLabPortInfo getMidiInputPort();

    public void setMidiInputPort(WaxLabPortInfo var1);

    public MidiMapping[] getMidiMappings();

    public void setMidiMappings(MidiMapping[] var1);

    public MidiAction[] getMidiActions();

    public MidiAction getMidiAction(MidiMapping var1);

    public WaxLabPortInfo getMidiOutputPort();

    public void setMidiOutputPort(WaxLabPortInfo var1);

    public void handleMidiTargetChanged(MidiOutputPort var1);

    public MidiTrigger[] getMidiTriggers();

    public void setMidiTriggers(MidiTrigger[] var1);

    public String[] getMidiEvents();

    public void start(long var1) throws Exception;

    public void stop() throws Exception;

    public boolean isActive();

    public void refreshMidiLightings();

    public Properties getProperties();

    public void setProperties(Properties var1);

    public String getProperty(String var1);

    public void setProperty(String var1, String var2);

    public MediaPlayer[] getLineMediaPlayers();

    public MediaEntry getMediaEntry(Resource var1) throws IOException;

    public MediaEntry getMediaEntry(Resource var1, int var2) throws IOException;

    public boolean updateMediaMarkers(MutableMediaEntry var1, MediaMarker[] var2) throws IOException;

    public void copySampleModel(SampleModel var1, long var2, SampleModel var4, long var5, long var7, SampleBuffer var9) throws IOException;
}

