/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.FeatureLabelToolkit;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class BeanListCellRenderer
extends AbstractCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = 2703192921977243570L;
    private FeatureLabelToolkit featureLabelToolkit;
    private BeansToolkit beansToolkit;

    public BeanListCellRenderer(BeansToolkit newBeansToolkit, FeatureLabelToolkit newFeatureLabelToolkit) {
        this.setLayout(new GridLayout(1, 1));
        this.setBeansToolkit(newBeansToolkit);
        this.setFeatureLabelToolkit(newFeatureLabelToolkit);
    }

    protected BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public FeatureLabelToolkit getFeatureLabelToolkit() {
        return this.featureLabelToolkit;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setSelected(isSelected);
        this.setFocus(cellHasFocus);
        Object bean = value;
        FeatureDescriptor feature = null;
        if (bean != null) {
            try {
                BeanInfo info = this.getBeansToolkit().getBeanInfo(bean.getClass());
                if (info != null) {
                    feature = info.getBeanDescriptor();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setToolTipText(feature == null ? null : feature.getShortDescription());
        this.getFeatureLabelToolkit().getFeatureLabel(this.getBeansToolkit(), feature, bean);
        return this;
    }

    private void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    private void setFeatureLabelToolkit(FeatureLabelToolkit newFeatureLabelToolkit) {
        this.featureLabelToolkit = newFeatureLabelToolkit;
        this.removeAll();
        if (newFeatureLabelToolkit != null) {
            this.add(newFeatureLabelToolkit.getFeatureLabel());
        }
    }
}

