/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.beans.model.BeanTreeNode;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BeanTree
extends JTree {
    private static final long serialVersionUID = 7921214103222735939L;

    @Override
    public boolean isPathEditable(TreePath path) {
        if (!this.isEditable()) {
            return false;
        }
        Object node = path.getLastPathComponent();
        if (node == null) {
            return false;
        }
        if (node instanceof BeanTreeNode) {
            BeanTreeNode beanNode = (BeanTreeNode)path.getLastPathComponent();
            FeatureDescriptor feature = beanNode.getFeatureDescriptor();
            if (feature == null) {
                return false;
            }
            if (feature instanceof PropertyDescriptor) {
                PropertyDescriptor prop = (PropertyDescriptor)feature;
                return prop.getReadMethod() != null && prop.getWriteMethod() != null;
            }
        }
        return false;
    }

    public void refresh() {
        TreeModel model = this.getModel();
        TreeSelectionModel selModel = this.getSelectionModel();
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath path;
            if (!this.isExpanded(i) || (path = this.getPathForRow(i)) == null) continue;
            expandedPaths.add(path);
        }
        this.setSelectionModel(new DefaultTreeSelectionModel());
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.validate();
        this.setModel(model);
        for (TreePath path : expandedPaths) {
            this.expandPath(path);
        }
        this.setSelectionModel(selModel);
        this.validate();
        this.repaint();
    }
}

