/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.AbstractPropertyEditorCellEditor;
import com.spacekiller.util.beans.components.AbstractPropertyEditorCellRenderer;
import com.spacekiller.util.beans.components.BeanTree;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellEditor;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellRenderer;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellToolkit;
import com.spacekiller.util.beans.components.FeatureLabelToolkit;
import com.spacekiller.util.beans.model.BeanModel;
import com.spacekiller.util.beans.model.BeanTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BeanTreeCellToolkit
implements MouseListener,
MouseMotionListener {
    public static final int TYPE_RENDERER = 0;
    public static final int TYPE_EDITOR = 1;
    private BeansToolkit beansToolkit;
    private PreferredWidthComponent pwdc1;
    private PreferredWidthComponent pwdc2;
    private DefaultPropertyEditorCellToolkit propertyEditorCellToolkit;
    private Vector vPropertyDescr = new Vector();
    private Vector vPropertyEditor = new Vector();
    private Vector vPropertyEditorBeanContext = new Vector();
    private AbstractPropertyEditorCellRenderer propertyEditorCellRenderer;
    private AbstractPropertyEditorCellEditor propertyEditorCellEditor;
    private FeatureLabelToolkit featureLabelToolkit;
    private Object value;
    private int defaultLabelMinWidth = 10;
    private int defaultLabelMaxWidth = -1;
    private int defaultValueMinWidth = 0;
    private int defaultValueMaxWidth = 0;
    private int propertyLabelMinWidth = 100;
    private int propertyLabelMaxWidth = 100;
    private int propertyValueMinWidth = 150;
    private int propertyValueMaxWidth = -1;
    private CellEditor peerCellEditor;
    private BeanTree beanTree;
    private boolean wasResizeArea = false;
    private int resizeStartX = -1;
    private TreePath resizePath;
    private Rectangle resizeDividerBounds;
    private static final Logger logger = Logger.getLogger(BeanTreeCellToolkit.class.getName());

    public BeanTreeCellToolkit(JComponent cellComponent, BeansToolkit newBeansToolkit, int type, FeatureLabelToolkit featureLabelToolkit, CellEditor newPeerCellEditor, BeanTree beanTree) {
        this.initDefaultFeatureTreeCellToolkit(cellComponent, newBeansToolkit, type, featureLabelToolkit, newPeerCellEditor, beanTree);
    }

    protected FeatureLabelToolkit createFeatureLabelToolkit() {
        return new FeatureLabelToolkit();
    }

    protected DefaultPropertyEditorCellEditor createPropertyEditorCellEditor() {
        DefaultPropertyEditorCellEditor rc = new DefaultPropertyEditorCellEditor(this.getPropertyEditorCellToolkit());
        rc.setCellBackground(null);
        rc.setCellSelectionBackground(null);
        rc.setCellFocusColor(null);
        rc.setPeerCellEditor(this.getPeerCellEditor());
        return rc;
    }

    protected AbstractPropertyEditorCellRenderer createPropertyEditorCellRenderer() {
        DefaultPropertyEditorCellRenderer rc = new DefaultPropertyEditorCellRenderer(this.getPropertyEditorCellToolkit());
        rc.setCellBackground(null);
        rc.setCellSelectionBackground(null);
        rc.setCellFocusColor(null);
        return rc;
    }

    protected DefaultPropertyEditorCellToolkit createPropertyEditorCellToolkit() {
        return new DefaultPropertyEditorCellToolkit(this.getBeansToolkit(), this.getBeanModel(), 0, this.vPropertyDescr, this.vPropertyEditor, this.vPropertyEditorBeanContext);
    }

    protected BeanModel getBeanModel() {
        TreeModel model;
        BeanTree tree = this.getBeanTree();
        if (tree != null && (model = tree.getModel()) != null && model instanceof BeanModel) {
            return (BeanModel)((Object)model);
        }
        return null;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public BeanTree getBeanTree() {
        return this.beanTree;
    }

    public int getDefaultLabelMaxWidth() {
        return this.defaultLabelMaxWidth;
    }

    public int getDefaultLabelMinWidth() {
        return this.defaultLabelMinWidth;
    }

    public int getDefaultValueMaxWidth() {
        return this.defaultValueMaxWidth;
    }

    public int getDefaultValueMinWidth() {
        return this.defaultValueMinWidth;
    }

    public FeatureLabelToolkit getFeatureLabelToolkit() {
        if (this.featureLabelToolkit == null) {
            this.featureLabelToolkit = this.createFeatureLabelToolkit();
        }
        return this.featureLabelToolkit;
    }

    protected CellEditor getPeerCellEditor() {
        return this.peerCellEditor;
    }

    public AbstractPropertyEditorCellEditor getPropertyEditorCellEditor() {
        return this.propertyEditorCellEditor;
    }

    public AbstractPropertyEditorCellRenderer getPropertyEditorCellRenderer() {
        return this.propertyEditorCellRenderer;
    }

    public DefaultPropertyEditorCellToolkit getPropertyEditorCellToolkit() {
        return this.propertyEditorCellToolkit;
    }

    protected Class getPropertyEditorClass(PropertyDescriptor property) {
        if (property == null) {
            return null;
        }
        BeansToolkit tk = this.getBeansToolkit();
        if (tk == null) {
            return null;
        }
        Iterator i = tk.getPropertyEditorClasses(property);
        if (i == null) {
            return null;
        }
        return i.hasNext() ? (Class)i.next() : null;
    }

    public String getPropertyEditorToolTip() {
        Object value = this.getValue();
        String rc = null;
        if (value != null && value instanceof BeanTreeNode) {
            rc = this.getPropertyEditorCellToolkit().getPropertyEditorToolTip(this.getPropertyEditorCellToolkit().getPropertyEditor(0, 0), 0, 0);
        }
        if (rc != null && rc.length() < 1) {
            rc = null;
        }
        return rc;
    }

    public int getPropertyLabelMaxWidth() {
        return this.propertyLabelMaxWidth;
    }

    public int getPropertyLabelMinWidth() {
        return this.propertyLabelMinWidth;
    }

    public String getPropertyLabelToolTip() {
        BeanTreeNode node;
        FeatureDescriptor feature;
        Object value = this.getValue();
        String rc = null;
        if (value != null && value instanceof BeanTreeNode && (feature = (node = (BeanTreeNode)value).getFeatureDescriptor()) != null) {
            rc = feature.getShortDescription();
        }
        if (rc != null && rc.length() < 1) {
            rc = null;
        }
        return rc;
    }

    public int getPropertyValueMaxWidth() {
        return this.propertyValueMaxWidth;
    }

    public int getPropertyValueMinWidth() {
        return this.propertyValueMinWidth;
    }

    protected Object getValue() {
        return this.value;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.WARNING, this.getClass().getName(), e);
    }

    protected void initDefaultFeatureTreeCellToolkit(JComponent cellComponent, BeansToolkit newBeansToolkit, int type, FeatureLabelToolkit featureLabelToolkit, CellEditor newPeerCellEditor, BeanTree beanTree) {
        this.setBeansToolkit(newBeansToolkit);
        this.setPeerCellEditor(newPeerCellEditor);
        this.pwdc1 = new PreferredWidthComponent();
        this.pwdc1.setLayout(new GridLayout(1, 1));
        this.setFeatureLabelToolkit(featureLabelToolkit);
        this.pwdc1.add(featureLabelToolkit.getFeatureLabel());
        this.pwdc2 = new PreferredWidthComponent();
        this.pwdc2.setLayout(new GridLayout(1, 1));
        this.setPropertyEditorCellToolkit(this.createPropertyEditorCellToolkit());
        Object valueComponent = null;
        switch (type) {
            case 0: {
                this.setPropertyEditorCellRenderer(this.createPropertyEditorCellRenderer());
                valueComponent = this.getPropertyEditorCellRenderer();
                break;
            }
            case 1: {
                this.setPropertyEditorCellEditor(this.createPropertyEditorCellEditor());
                valueComponent = this.getPropertyEditorCellEditor();
            }
        }
        if (valueComponent != null) {
            this.pwdc2.add((Component)valueComponent);
        }
        cellComponent.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 5);
        cellComponent.add((Component)this.pwdc1, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        cellComponent.add((Component)this.pwdc2, gbc);
        this.setBeanTree(beanTree);
    }

    protected TreePath isResizeArea(int x, int y) {
        int w;
        BeanTree tree = this.getBeanTree();
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getPathForLocation(x, y);
        if (path == null) {
            return null;
        }
        Rectangle rect = tree.getPathBounds(path);
        if (rect == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof BeanTreeNode && x > rect.x + (w = this.getPropertyLabelMinWidth()) - 5 && x < rect.x + w + 5) {
            return path;
        }
        return null;
    }

    protected TreePath isValueArea(int x, int y) {
        int w;
        BeanTree tree = this.getBeanTree();
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getPathForLocation(x, y);
        if (path == null) {
            return null;
        }
        Rectangle rect = tree.getPathBounds(path);
        if (rect == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof BeanTreeNode && x < rect.x + (w = this.getPropertyLabelMinWidth())) {
            return path;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Rectangle rect;
        BeanTree tree = this.getBeanTree();
        if (tree != null && this.resizeStartX >= 0 && this.resizePath != null && (rect = tree.getPathBounds(this.resizePath)) != null) {
            if (this.resizeDividerBounds != null) {
                this.paintResizeDivider(tree, this.resizeDividerBounds);
            }
            this.resizeDividerBounds = new Rectangle(e.getX(), rect.y, 5, rect.height);
            this.paintResizeDivider(tree, this.resizeDividerBounds);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        BeanTree tree = this.getBeanTree();
        if (tree != null) {
            tree.setCursor(Cursor.getDefaultCursor());
        }
        this.wasResizeArea = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        BeanTree tree = this.getBeanTree();
        if (tree != null) {
            boolean isArea;
            TreePath path = this.isResizeArea(e.getX(), e.getY());
            boolean bl = isArea = path != null;
            if (isArea == this.wasResizeArea) {
                return;
            }
            this.wasResizeArea = isArea;
            if (isArea) {
                tree.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                tree.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        BeanTree tree = this.getBeanTree();
        if (tree != null) {
            TreePath path = this.isResizeArea(e.getX(), e.getY());
            if (path != null) {
                logger.fine(" => pressed=" + e);
                this.resizeStartX = e.getX();
                this.resizePath = path;
            } else {
                this.resizeStartX = -1;
                this.resizePath = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        BeanTree tree;
        if (!e.isPopupTrigger() && (tree = this.getBeanTree()) != null && this.resizeStartX >= 0 && this.resizePath != null) {
            int delta = e.getX() - this.resizeStartX;
            this.setPropertyLabelMinWidth(this.getPropertyLabelMinWidth() + delta);
            this.setPropertyLabelMaxWidth(this.getPropertyLabelMinWidth());
            if (this.resizeDividerBounds != null) {
                this.paintResizeDivider(tree, this.resizeDividerBounds);
                this.resizeDividerBounds = null;
            }
            tree.validate();
            tree.repaint();
        }
        this.resizeStartX = -1;
        this.resizePath = null;
    }

    protected void paintResizeDivider(BeanTree tree, Rectangle rect) {
        Graphics g = tree.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setPaintMode();
        g.dispose();
    }

    protected Object prepareTreeCell(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        BeansToolkit btk = this.getBeansToolkit();
        this.setValue(value);
        Object rendererValue = null;
        int labelMinWidth = this.getDefaultLabelMinWidth();
        int labelMaxWidth = this.getDefaultLabelMaxWidth();
        int valueMinWidth = this.getDefaultValueMinWidth();
        int valueMaxWidth = this.getDefaultValueMaxWidth();
        this.vPropertyDescr.removeAllElements();
        this.vPropertyEditor.removeAllElements();
        this.vPropertyEditorBeanContext.removeAllElements();
        if (btk != null && value != null && value instanceof BeanTreeNode) {
            BeanTreeNode treeNode = (BeanTreeNode)value;
            Object bean = treeNode.getBean();
            FeatureDescriptor feature = treeNode.getFeatureDescriptor();
            if (feature != null) {
                this.getFeatureLabelToolkit().getFeatureLabel(btk, feature, bean);
                if (feature instanceof PropertyDescriptor) {
                    try {
                        labelMinWidth = this.getPropertyLabelMinWidth();
                        labelMaxWidth = this.getPropertyLabelMaxWidth();
                        valueMinWidth = this.getPropertyValueMinWidth();
                        valueMaxWidth = this.getPropertyValueMaxWidth();
                        PropertyDescriptor property = (PropertyDescriptor)feature;
                        rendererValue = btk.getValue(property, bean);
                        this.vPropertyDescr.addElement(property);
                        Class editorClass = property.getPropertyEditorClass();
                        if (editorClass == null) {
                            editorClass = this.getPropertyEditorClass(property);
                        }
                        PropertyEditor propertyEd = null;
                        if (editorClass != null) {
                            propertyEd = btk.getPropertyEditor(editorClass);
                        }
                        this.vPropertyEditor.addElement(propertyEd);
                    }
                    catch (Throwable e) {
                        this.handleException(e);
                    }
                }
            }
        }
        this.pwdc1.setPrefWidth(labelMinWidth);
        this.pwdc1.setMaxWidth(labelMaxWidth);
        this.pwdc2.setPrefWidth(valueMinWidth);
        this.pwdc2.setMaxWidth(valueMaxWidth);
        return rendererValue;
    }

    public void prepareTreeCellEditor(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Object rendererValue = this.prepareTreeCell(tree, value, selected, expanded, leaf, row, true);
        this.propertyEditorCellEditor.getTreeCellEditorComponent(tree, rendererValue, false, expanded, leaf, 0);
    }

    public void prepareTreeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object rendererValue = this.prepareTreeCell(tree, value, selected, expanded, leaf, row, hasFocus);
        this.propertyEditorCellRenderer.getTreeCellRendererComponent(tree, rendererValue, false, expanded, leaf, 0, false);
    }

    private void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    public void setBeanTree(BeanTree newBeanTree) {
        if (this.beanTree != null) {
            this.beanTree.removeMouseListener(this);
            this.beanTree.removeMouseMotionListener(this);
        }
        this.beanTree = newBeanTree;
        if (newBeanTree != null) {
            newBeanTree.addMouseListener(this);
            newBeanTree.addMouseMotionListener(this);
        }
    }

    public void setDefaultLabelMaxWidth(int newDefaultLabelMaxWidth) {
        this.defaultLabelMaxWidth = newDefaultLabelMaxWidth;
    }

    public void setDefaultLabelMinWidth(int newDefaultLabelMinWidth) {
        this.defaultLabelMinWidth = newDefaultLabelMinWidth;
    }

    public void setDefaultValueMaxWidth(int newDefaultValueMaxWidth) {
        this.defaultValueMaxWidth = newDefaultValueMaxWidth;
    }

    public void setDefaultValueMinWidth(int newDefaultValueMinWidth) {
        this.defaultValueMinWidth = newDefaultValueMinWidth;
    }

    private void setFeatureLabelToolkit(FeatureLabelToolkit newFeatureLabelToolkit) {
        this.featureLabelToolkit = newFeatureLabelToolkit;
    }

    private void setPeerCellEditor(CellEditor newPeerCellEditor) {
        this.peerCellEditor = newPeerCellEditor;
    }

    private void setPropertyEditorCellEditor(AbstractPropertyEditorCellEditor newPropertyEditorCellEditor) {
        this.propertyEditorCellEditor = newPropertyEditorCellEditor;
    }

    private void setPropertyEditorCellRenderer(AbstractPropertyEditorCellRenderer newPropertyEditorCellRenderer) {
        this.propertyEditorCellRenderer = newPropertyEditorCellRenderer;
    }

    private void setPropertyEditorCellToolkit(DefaultPropertyEditorCellToolkit newPropertyEditorCellToolkit) {
        this.propertyEditorCellToolkit = newPropertyEditorCellToolkit;
    }

    public void setPropertyLabelMaxWidth(int newPropertyLabelMaxWidth) {
        this.propertyLabelMaxWidth = newPropertyLabelMaxWidth;
    }

    public void setPropertyLabelMinWidth(int newPropertyLabelMinWidth) {
        this.propertyLabelMinWidth = newPropertyLabelMinWidth;
    }

    public void setPropertyValueMaxWidth(int newPropertyValueMaxWidth) {
        this.propertyValueMaxWidth = newPropertyValueMaxWidth;
    }

    public void setPropertyValueMinWidth(int newPropertyValueMinWidth) {
        this.propertyValueMinWidth = newPropertyValueMinWidth;
    }

    protected void setValue(Object newValue) {
        this.value = newValue;
    }

    public class PreferredWidthComponent
    extends JComponent {
        private static final long serialVersionUID = -7018053233550456503L;
        private int prefWidth = -1;
        private int maxWidth = -1;

        @Override
        public Dimension getPreferredSize() {
            int w = 0;
            int h = 0;
            Dimension dim = super.getPreferredSize();
            if (dim != null) {
                w = dim.width;
                h = dim.height;
            }
            if (this.prefWidth >= 0 && this.prefWidth > w) {
                w = this.prefWidth;
            }
            if (this.maxWidth >= 0 && this.maxWidth < w) {
                w = this.maxWidth;
            }
            return new Dimension(w, h);
        }

        public void setPrefWidth(int i) {
            this.prefWidth = i;
        }

        public int getPrefWidth() {
            return this.prefWidth;
        }

        public void setMaxWidth(int i) {
            this.maxWidth = i;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }
    }
}

