/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassDescriptor;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.swing.DocumentAdapter;
import com.spacekiller.util.swing.TransListCellRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClassChooser
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = -138200646307531722L;
    public static int EMPTY_DO_NOTHING = 0;
    public static int EMPTY_SEARCH_ALL = 1;
    private ClassRegistry classRegistry;
    private BeansToolkit beansToolkit;
    private JLabel jLabel = null;
    private JTextField jTextFieldClass = null;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private transient ActionListener actionListeners;
    private transient ItemListener itemListeners;
    private Font rendererFont;
    private Icon classIcon;
    private Icon interfaceIcon;
    private Icon abstractIcon;
    private DefaultListModel classListModel;
    private ClassRefresher classRefresher = new ClassRefresher();
    private Thread classRefresherThread;
    private boolean cancelSearch = false;
    private JLabel jLabel1 = null;
    private Filter classFilter;
    private Comparator classComparator = new DefaultClassComparator();
    private int emptySearchAction = EMPTY_DO_NOTHING;
    private static final Logger logger = Logger.getLogger(ClassChooser.class.getName());

    public ClassChooser() {
        this.initialize();
        this.initClassChooser();
    }

    protected void initClassChooser() {
        this.setRendererFont(new Font("dialog", 0, 12));
        this.getJList().setCellRenderer(new ClassDescriptorListCellRenderer());
        this.getJList().setSelectionMode(0);
        this.classListModel = new DefaultListModel();
        this.getJList().setModel(this.classListModel);
        this.getJTextFieldClass().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                ClassChooser.this.refreshClasses();
            }
        });
        try {
            this.setClassIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/class2.gif")));
            this.setInterfaceIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/interface.gif")));
            this.setAbstractIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/abstract_class.gif")));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridwidth = 2;
        gridBagConstraints11.gridy = 1;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Available classes:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints2.gridx = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.jLabel = new JLabel();
        this.jLabel.setText("Search:");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(467, 361));
        this.add((Component)this.jLabel, gridBagConstraints);
        this.add((Component)this.getJTextFieldClass(), gridBagConstraints1);
        this.add((Component)this.getJScrollPane(), gridBagConstraints2);
        this.add((Component)this.jLabel1, gridBagConstraints11);
    }

    private JTextField getJTextFieldClass() {
        if (this.jTextFieldClass == null) {
            this.jTextFieldClass = new JTextField();
        }
        return this.jTextFieldClass;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setOpaque(false);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ClassChooser.this.handleSelectionChanged();
                }
            });
            this.jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        ClassChooser.this.handleDoubleClick();
                    }
                }
            });
        }
        return this.jList;
    }

    public ClassRegistry getClassRegistry() {
        if (this.classRegistry == null) {
            this.setClassRegistry(Platform.getInstance().getClassRegistry());
        }
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        if (this.itemListeners == null) {
            return;
        }
        this.itemListeners.itemStateChanged(e);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.itemListeners, ItemListener.class);
    }

    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(Platform.getInstance().getBeansToolkit());
        }
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public Font getRendererFont() {
        return this.rendererFont;
    }

    public void setRendererFont(Font rendererFont) {
        this.rendererFont = rendererFont;
    }

    public synchronized void refresh() {
        this.refreshClasses();
    }

    protected void refreshClasses() {
        String search = this.getJTextFieldClass().getText().toLowerCase();
        boolean running = this.classRefresher.isRunning();
        this.classRefresher.setSearch(search);
        this.cancelSearch = running;
        if (!running) {
            this.classRefresherThread = new Thread(this.classRefresher);
            this.classRefresherThread.start();
        }
    }

    protected void searchClasses(String search) {
        this.setWaitingCursor(true);
        TreeSet<ClassDescriptor> sortedSet = this.classComparator == null ? new TreeSet<ClassDescriptor>() : new TreeSet(this.classComparator);
        boolean doSearch = false;
        if (search.length() > 0) {
            doSearch = true;
        } else {
            int emptyAction = this.getEmptySearchAction();
            if (emptyAction == EMPTY_SEARCH_ALL) {
                doSearch = true;
            }
        }
        ClassRegistry classRegistry = this.getClassRegistry();
        if (classRegistry != null && doSearch) {
            Enumeration en = classRegistry.getClassDescriptors();
            while (en.hasMoreElements() && !this.cancelSearch) {
                ClassDescriptor cd = (ClassDescriptor)en.nextElement();
                String s = cd.getClassName();
                if (s.toLowerCase().indexOf(search) < 0 || this.classFilter != null && !this.classFilter.accept((Object)cd)) continue;
                sortedSet.add(cd);
            }
        }
        this.classListModel = new DefaultListModel();
        Iterator i = sortedSet.iterator();
        while (i.hasNext()) {
            this.classListModel.addElement(i.next());
        }
        this.getJList().setModel(this.classListModel);
        this.setWaitingCursor(false);
    }

    public Icon getClassIcon() {
        return this.classIcon;
    }

    public void setClassIcon(Icon classIcon) {
        this.classIcon = classIcon;
    }

    public Icon getInterfaceIcon() {
        return this.interfaceIcon;
    }

    public void setInterfaceIcon(Icon interfaceIcon) {
        this.interfaceIcon = interfaceIcon;
    }

    protected void handleSelectionChanged() {
        Object item = this.getJList().getSelectedValue();
        ItemEvent ev = new ItemEvent(this, 701, item, 1);
        this.fireItemStateChanged(ev);
    }

    protected void handleDoubleClick() {
        ActionEvent ev = new ActionEvent(this, 1001, "action");
        this.fireActionPerformed(ev);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        Object item = this.getJList().getSelectedValue();
        if (item == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = item;
        }
        return objectArray;
    }

    public ClassDescriptor getSelectedClassDescriptor() {
        Object item = this.getJList().getSelectedValue();
        if (item != null) {
            return (ClassDescriptor)item;
        }
        return null;
    }

    public Icon getAbstractIcon() {
        return this.abstractIcon;
    }

    public void setAbstractIcon(Icon abstractIcon) {
        this.abstractIcon = abstractIcon;
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
    }

    protected void setWaitingCursor(boolean wait) {
        if (wait) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            if (cursor != null) {
                this.setCursor(cursor);
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public Comparator getClassComparator() {
        return this.classComparator;
    }

    public void setClassComparator(Comparator classComparator) {
        this.classComparator = classComparator;
    }

    public static String shortClassName(String className) {
        String text = className;
        int x = text.lastIndexOf(".");
        if (x >= 0) {
            text = text.substring(x + 1);
        }
        return text;
    }

    public int getEmptySearchAction() {
        return this.emptySearchAction;
    }

    public void setEmptySearchAction(int emptySearchAction) {
        this.emptySearchAction = emptySearchAction;
    }

    public static class DefaultClassComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            String bShort;
            ClassDescriptor a = (ClassDescriptor)arg0;
            ClassDescriptor b = (ClassDescriptor)arg1;
            String aName = a.getClassName();
            String bName = b.getClassName();
            String aShort = ClassChooser.shortClassName(aName);
            int rc = aShort.compareToIgnoreCase(bShort = ClassChooser.shortClassName(bName));
            if (rc != 0) {
                return rc;
            }
            return aName.compareToIgnoreCase(bName);
        }
    }

    public static class MultiClassFilter
    implements Filter {
        private Filter[] filters;

        public MultiClassFilter(Filter[] filters) {
            this.filters = filters;
        }

        public boolean accept(Object o) {
            Filter[] f = this.filters;
            for (int i = 0; i < f.length; ++i) {
                if (f[i].accept(o)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AssignableFromClassFilter
    implements Filter {
        private ClassRegistry classRegistry;
        private String className;

        public AssignableFromClassFilter(ClassRegistry classRegistry, String className) {
            this.classRegistry = classRegistry;
            this.className = className;
        }

        public boolean accept(Object o) {
            ClassDescriptor descr = (ClassDescriptor)o;
            return this.classRegistry.isTypeAssignableFrom(this.className, descr);
        }
    }

    public static class PublicConstructorClassFilter
    implements Filter {
        public boolean accept(Object o) {
            ClassDescriptor descr = (ClassDescriptor)o;
            if (descr.isInterface()) {
                return false;
            }
            if (descr.isAbstract()) {
                return false;
            }
            return descr.hasPublicConstructor();
        }
    }

    public static class DefaultConstructorClassFilter
    implements Filter {
        public boolean accept(Object o) {
            ClassDescriptor descr = (ClassDescriptor)o;
            if (descr.isInterface()) {
                return false;
            }
            if (descr.isAbstract()) {
                return false;
            }
            return descr.hasDefaultConstructor();
        }
    }

    public static class MainClassFilter
    implements Filter {
        public boolean accept(Object o) {
            ClassDescriptor descr = (ClassDescriptor)o;
            if (descr.isInterface()) {
                return false;
            }
            if (descr.isAbstract()) {
                return false;
            }
            return descr.hasMainMethod();
        }
    }

    public static class DefaultClassFilter
    implements Filter {
        private boolean includeInterfaces = false;
        private boolean includeAbstractClasses = false;
        private boolean includeConcreteClasses = false;
        private boolean includeInnerClasses = false;
        private boolean includeInnerStaticClasses = false;
        private boolean includeNonMainClasses = true;
        private boolean includeNonDefaultConstructorClasses = true;
        private boolean includeNonPublicConstructorClasses = true;

        public boolean accept(Object o) {
            ClassDescriptor descr = (ClassDescriptor)o;
            if (!this.includeNonMainClasses && !descr.hasMainMethod()) {
                return false;
            }
            if (!this.includeNonDefaultConstructorClasses && !descr.hasDefaultConstructor()) {
                return false;
            }
            if (!this.includeNonPublicConstructorClasses && !descr.hasPublicConstructor()) {
                return false;
            }
            if (!this.includeInnerClasses && descr.isInnerClass()) {
                if (this.includeInnerStaticClasses) {
                    if (!descr.isStatic()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (descr.isInterface()) {
                return this.includeInterfaces;
            }
            if (descr.isAbstract()) {
                return this.includeAbstractClasses;
            }
            return this.includeConcreteClasses;
        }

        public boolean isIncludeAbstractClasses() {
            return this.includeAbstractClasses;
        }

        public void setIncludeAbstractClasses(boolean includeAbstractClasses) {
            this.includeAbstractClasses = includeAbstractClasses;
        }

        public boolean isIncludeConcreteClasses() {
            return this.includeConcreteClasses;
        }

        public void setIncludeConcreteClasses(boolean includeConcreteClasses) {
            this.includeConcreteClasses = includeConcreteClasses;
        }

        public boolean isIncludeInterfaces() {
            return this.includeInterfaces;
        }

        public void setIncludeInterfaces(boolean includeInterfaces) {
            this.includeInterfaces = includeInterfaces;
        }

        public boolean isIncludeInnerClasses() {
            return this.includeInnerClasses;
        }

        public void setIncludeInnerClasses(boolean includeInnerClasses) {
            this.includeInnerClasses = includeInnerClasses;
        }

        public boolean isIncludeInnerStaticClasses() {
            return this.includeInnerStaticClasses;
        }

        public void setIncludeInnerStaticClasses(boolean includeInnerStaticClasses) {
            this.includeInnerStaticClasses = includeInnerStaticClasses;
        }

        public boolean isIncludeNonDefaultConstructorClasses() {
            return this.includeNonDefaultConstructorClasses;
        }

        public void setIncludeNonDefaultConstructorClasses(boolean includeNonDefaultConstructorClasses) {
            this.includeNonDefaultConstructorClasses = includeNonDefaultConstructorClasses;
        }

        public boolean isIncludeNonMainClasses() {
            return this.includeNonMainClasses;
        }

        public void setIncludeNonMainClasses(boolean includeNonMainClasses) {
            this.includeNonMainClasses = includeNonMainClasses;
        }

        public boolean isIncludeNonPublicConstructorClasses() {
            return this.includeNonPublicConstructorClasses;
        }

        public void setIncludeNonPublicConstructorClasses(boolean includeNonPublicConstructorClasses) {
            this.includeNonPublicConstructorClasses = includeNonPublicConstructorClasses;
        }
    }

    protected class ClassRefresher
    implements Runnable {
        private boolean running = false;
        private String search;
        private boolean searchChanged = false;

        protected ClassRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.running = true;
                while (this.searchChanged) {
                    this.searchChanged = false;
                    ClassChooser.this.cancelSearch = false;
                    ClassChooser.this.searchClasses(this.search);
                }
            }
            finally {
                this.running = false;
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setSearch(String s) {
            if (this.search != null && s != null && this.search.equals(s)) {
                return;
            }
            this.search = s;
            this.searchChanged = true;
        }
    }

    public class ClassDescriptorListCellRenderer
    extends TransListCellRenderer {
        private static final long serialVersionUID = -2240670857311254962L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object o = value;
            Component rc = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (o != null && o instanceof ClassDescriptor) {
                ClassDescriptor descr = (ClassDescriptor)o;
                this.setFont(ClassChooser.this.getRendererFont());
                String text = ClassChooser.shortClassName(descr.getClassName());
                String tip = descr.getClassName();
                Icon icon = ClassChooser.this.classIcon;
                if (descr.isInterface()) {
                    icon = ClassChooser.this.interfaceIcon;
                } else if (descr.isAbstract()) {
                    icon = ClassChooser.this.abstractIcon;
                }
                this.setText(text);
                this.setIcon(icon);
                this.setToolTipText(tip);
            }
            return rc;
        }
    }
}

