/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.beans.components.ClassChooserField;
import com.spacekiller.util.swing.DocumentAdapter;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewArrayPanel
extends JPanel {
    private static final long serialVersionUID = -8398240917325047886L;
    private ClassRegistry classRegistry;
    private BeansToolkit beansToolkit;
    private Filter classFilter;
    private JTextField jTextFieldDimensions = null;
    private JButton jButtonCreate = null;
    private JRadioButton jRadioButtonPrimitive = null;
    private JRadioButton jRadioButtonObject = null;
    private ClassChooserField classChooserField = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel = null;
    private JTextField jTextFieldLength = null;
    private JComboBox jComboBoxType = null;
    private transient ActionListener actionListeners;

    public NewArrayPanel() {
        this.initialize();
        this.initNewArrayPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
        gridBagConstraints71.gridx = 0;
        gridBagConstraints71.fill = 2;
        gridBagConstraints71.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints71.gridy = 1;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 0.0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints6.gridy = 0;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.anchor = 13;
        gridBagConstraints21.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints21.gridy = 5;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridx = 3;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(377, 177));
        this.add((Component)this.getJButtonCreate(), gridBagConstraints21);
        this.add((Component)this.getJPanel(), gridBagConstraints6);
        this.add((Component)this.getJPanel1(), gridBagConstraints71);
    }

    private JTextField getJTextFieldDimensions() {
        if (this.jTextFieldDimensions == null) {
            this.jTextFieldDimensions = new JTextField();
            this.jTextFieldDimensions.setColumns(4);
            this.jTextFieldDimensions.setToolTipText("Array dimensions");
        }
        return this.jTextFieldDimensions;
    }

    private JButton getJButtonCreate() {
        if (this.jButtonCreate == null) {
            this.jButtonCreate = new JButton();
            this.jButtonCreate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/newaccessbean_wiz.gif")));
            this.jButtonCreate.setText("Create");
            this.jButtonCreate.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewArrayPanel.this.actionCreate();
                }
            });
        }
        return this.jButtonCreate;
    }

    private JRadioButton getJRadioButtonPrimitive() {
        if (this.jRadioButtonPrimitive == null) {
            this.jRadioButtonPrimitive = new JRadioButton();
            this.jRadioButtonPrimitive.setText("Primitive type:");
            this.jRadioButtonPrimitive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewArrayPanel.this.checkEnable();
                }
            });
        }
        return this.jRadioButtonPrimitive;
    }

    private JRadioButton getJRadioButtonObject() {
        if (this.jRadioButtonObject == null) {
            this.jRadioButtonObject = new JRadioButton();
            this.jRadioButtonObject.setText("Object type:");
            this.jRadioButtonObject.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewArrayPanel.this.checkEnable();
                }
            });
        }
        return this.jRadioButtonObject;
    }

    private ClassChooserField getClassChooserField() {
        if (this.classChooserField == null) {
            this.classChooserField = new ClassChooserField();
            this.classChooserField.setOpaque(false);
            this.classChooserField.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewArrayPanel.this.checkEnable();
                }
            });
        }
        return this.classChooserField;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints9.gridx = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridwidth = 3;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.getJRadioButtonPrimitive(), gridBagConstraints7);
            this.jPanel.add((Component)this.getJRadioButtonObject(), gridBagConstraints4);
            this.jPanel.add((Component)this.getClassChooserField(), gridBagConstraints5);
            this.jPanel.add((Component)this.getJComboBoxType(), gridBagConstraints9);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.gridy = 2;
            this.jLabel = new JLabel();
            this.jLabel.setText("Length:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 4;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.gridy = 2;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Dimensions:");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 5;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setOpaque(false);
            this.jPanel1.add((Component)this.getJTextFieldDimensions(), gridBagConstraints3);
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints2);
            this.jPanel1.add((Component)this.jLabel, gridBagConstraints);
            this.jPanel1.add((Component)this.getJTextFieldLength(), gridBagConstraints8);
        }
        return this.jPanel1;
    }

    private JTextField getJTextFieldLength() {
        if (this.jTextFieldLength == null) {
            this.jTextFieldLength = new JTextField();
            this.jTextFieldLength.setToolTipText("Array length");
            this.jTextFieldLength.setColumns(0);
        }
        return this.jTextFieldLength;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        this.getClassChooserField().setBeansToolkit(beansToolkit);
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
        this.getClassChooserField().setClassFilter(classFilter);
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
        this.getClassChooserField().setClassRegistry(classRegistry);
    }

    protected void initNewArrayPanel() {
        this.getJComboBoxType().removeAllItems();
        this.getJComboBoxType().addItem("byte");
        this.getJComboBoxType().addItem("char");
        this.getJComboBoxType().addItem("int");
        this.getJComboBoxType().addItem("long");
        this.getJComboBoxType().addItem("float");
        this.getJComboBoxType().addItem("double");
        this.getJComboBoxType().addItem("short");
        this.getJComboBoxType().addItem("boolean");
        DocumentAdapter docAdapter = new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                NewArrayPanel.this.checkEnable();
            }
        };
        this.getJTextFieldLength().getDocument().addDocumentListener((DocumentListener)docAdapter);
        this.getJTextFieldDimensions().getDocument().addDocumentListener((DocumentListener)docAdapter);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getJRadioButtonPrimitive());
        bg.add(this.getJRadioButtonObject());
        this.getJRadioButtonPrimitive().setSelected(true);
        this.getJTextFieldDimensions().setText("1");
        this.checkEnable();
    }

    private JComboBox getJComboBoxType() {
        if (this.jComboBoxType == null) {
            this.jComboBoxType = new JComboBox();
            this.jComboBoxType.setOpaque(false);
            this.jComboBoxType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewArrayPanel.this.checkEnable();
                }
            });
        }
        return this.jComboBoxType;
    }

    protected void checkEnable() {
        boolean enablePrimitive = this.getJRadioButtonPrimitive().isSelected();
        boolean enableObject = this.getJRadioButtonObject().isSelected();
        this.getJComboBoxType().setEnabled(enablePrimitive);
        this.getClassChooserField().setEnabled(enableObject);
        boolean enableCreate = false;
        try {
            int length = this.getArrayLength();
            int dims = this.getArrayDimensions();
            Class type = this.getArrayComponentType();
            if (type != null && length >= 0 && dims >= 1) {
                enableCreate = true;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.getJButtonCreate().setEnabled(enableCreate);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected void actionCreate() {
        ActionEvent ev = new ActionEvent(this, 1001, "create");
        this.fireActionPerformed(ev);
    }

    public Class getArrayComponentType() throws Exception {
        if (this.getJRadioButtonPrimitive().isSelected()) {
            String type = "" + this.getJComboBoxType().getSelectedItem();
            if ("boolean".equals(type)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(type)) {
                return Byte.TYPE;
            }
            if ("char".equals(type)) {
                return Character.TYPE;
            }
            if ("short".equals(type)) {
                return Short.TYPE;
            }
            if ("int".equals(type)) {
                return Integer.TYPE;
            }
            if ("long".equals(type)) {
                return Long.TYPE;
            }
            if ("float".equals(type)) {
                return Float.TYPE;
            }
            if ("double".equals(type)) {
                return Double.TYPE;
            }
            return null;
        }
        String className = this.getClassChooserField().getSelectedClassName();
        return Class.forName(className);
    }

    public int getArrayLength() throws Exception {
        return Integer.parseInt(this.getJTextFieldLength().getText().trim());
    }

    public int getArrayDimensions() throws Exception {
        return Integer.parseInt(this.getJTextFieldDimensions().getText().trim());
    }
}

