/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.beans.components.PropertyEditorDelegate;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.JComponent;

public class PaintablePropertyEditorDelegate
extends JComponent
implements PropertyEditorDelegate {
    private static final long serialVersionUID = -3070063223018576522L;
    private PropertyEditor propertyEditor;
    private boolean editable;

    public PaintablePropertyEditorDelegate() {
        this.initEditor();
    }

    protected void initEditor() {
        this.setOpaque(false);
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                PaintablePropertyEditorDelegate.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                PaintablePropertyEditorDelegate.this.requestFocus();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        if (!this.isEditable()) {
            return null;
        }
        return this.propertyEditor == null ? null : this.propertyEditor.getValue();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        PropertyEditor ed = this.getPropertyEditor();
        if (ed != null && ed.isPaintable()) {
            int w = this.getWidth();
            int h = this.getHeight();
            ed.paintValue(g, new Rectangle(0, 0, w, h));
        }
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setPropertyEditor(PropertyEditor newPropertyEditor) {
        this.propertyEditor = newPropertyEditor;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }
}

