/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Sys;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DefaultBeanContext;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.beans.components.NewObjectPanel;
import com.spacekiller.util.beans.components.PaintablePropertyEditorDelegate;
import com.spacekiller.util.beans.editors.ReferencePropertyEditor;
import com.spacekiller.util.swing.DocumentAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PropertyField
extends JComponent {
    private static final long serialVersionUID = 6265842908653152491L;
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private ClipboardManager clipboardManager;
    private Property property;
    private PropertyEditor propertyEditor;
    private PropertyEditor customPropertyEditor;
    private Component editorComponent;
    private boolean editable;
    private JButton customEditorButton;
    private boolean customEditorButtonVisible;
    private int customEditorButtonWidth = 14;
    private int customEditorButtonHeight = 14;
    private boolean customEditorDialogOpen = false;
    private FocusHandler focusHandler = new FocusHandler();
    private KeyHandler keyHandler = new KeyHandler();
    private PropertyChangeHandler propertyChangeHandler = new PropertyChangeHandler();
    private List keyListeners = new ArrayList();
    private boolean refreshing = false;
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private DropBeanContext dropBeanContext = new DropBeanContext();
    private DefaultDragSourceHandler dragSourceHandler;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private static final Logger logger = Logger.getLogger(PropertyField.class.getName());

    public PropertyField() {
        this.initPropertyField();
    }

    protected void initPropertyField() {
        this.editable = true;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder(1));
        this.setFocusable(false);
        this.addMouseListener(new MouseHandler());
        this.setMinimumSize(new Dimension(24, 20));
        this.setMaximumSize(new Dimension(1024, 50));
        DropTarget dt = new DropTarget(this, this.dropTargetHandler);
        this.setDropTarget(dt);
        this.initDragSource(this);
    }

    protected void initDragSource(Component comp) {
        DragSource ds = new DragSource();
        this.dragSourceHandler = new DefaultDragSourceHandler();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(comp, actions, this.dragGestureHandler);
        dgr.getComponent();
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property newProperty) {
        if (this.property != null) {
            this.property.removePropertyChangeListener((PropertyChangeListener)this.propertyChangeHandler);
        }
        this.property = newProperty;
        if (this.property != null) {
            this.property.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeHandler);
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            BeansToolkit btk = this.getBeansToolkit();
            Property p = this.getProperty();
            PropertyDescriptor pd = p == null ? null : p.getDescriptor();
            PropertyEditor editor = this.customPropertyEditor;
            if (editor == null && btk != null && pd != null) {
                editor = btk.getDefaultPropertyEditor(pd);
            }
            if (editor == null) {
                editor = new ReferencePropertyEditor();
            }
            Component editorComp = null;
            if (editor != null && p != null) {
                block16: {
                    this.propertyEditor = editor;
                    Object value = p.getValue();
                    try {
                        if (editor instanceof BeanEditor) {
                            BeanEditor be = (BeanEditor)editor;
                            be.setBeansToolkit(btk);
                            BeanContext bc = null;
                            if (value != null && value instanceof BeanContextChild) {
                                bc = ((BeanContextChild)value).getBeanContext();
                            }
                            be.setBeanContextOfBean(bc);
                            be.setBean(value);
                        } else {
                            editor.setValue(value);
                        }
                    }
                    catch (NullPointerException e) {
                        if (value == null) break block16;
                        throw e;
                    }
                }
                editorComp = this.createPropertyEditorComponent(editor);
            }
            if (editorComp == null) {
                JPanel dummy = new JPanel();
                dummy.setPreferredSize(this.getMinimumSize());
                dummy.setFocusable(true);
                editorComp = dummy;
            }
            if (editorComp instanceof JComponent) {
                boolean opaque = this.isOpaque();
                ((JComponent)editorComp).setOpaque(opaque);
            }
            this.setEditorComponent(editorComp);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            JPanel dummy = new JPanel();
            dummy.setPreferredSize(this.getMinimumSize());
            dummy.setFocusable(true);
            this.setEditorComponent(dummy);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected Component createPropertyEditorComponent(PropertyEditor editor) {
        String[] tags;
        if (editor.isPaintable()) {
            PaintablePropertyEditorDelegate editorComp = new PaintablePropertyEditorDelegate();
            editorComp.setEditable(this.editable);
            editorComp.setPropertyEditor(editor);
            return editorComp;
        }
        if (editor instanceof Component) {
            return (Component)((Object)editor);
        }
        Object value = editor.getValue();
        String text = null;
        if (value != null) {
            text = editor.getAsText();
        }
        if ((tags = editor.getTags()) != null && tags.length > 0) {
            JComboBox<String> combo = new JComboBox<String>();
            combo.setFocusable(true);
            combo.setBorder(new CompoundBorder());
            combo.setEditable(false);
            for (int i = 0; i < tags.length; ++i) {
                combo.addItem(tags[i]);
            }
            combo.setSelectedItem(text);
            combo.addItemListener(new ItemHandler());
            return combo;
        }
        JTextField textField = new JTextField();
        textField.setFocusable(true);
        textField.setBorder(new CompoundBorder());
        if (text == null) {
            text = "";
        }
        textField.setText(text);
        textField.setCaretPosition(0);
        textField.getDocument().addDocumentListener((DocumentListener)((Object)new DocumentHandler()));
        return textField;
    }

    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(Platform.getInstance().getBeansToolkit());
        }
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        if (beansToolkit != null && beansToolkit instanceof AbstractBeansToolkit) {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)beansToolkit;
            this.setBeanDropSupport(abt.getBeanDropSupport());
            this.setClipboardManager(abt.getClipboardManager());
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.refresh();
    }

    protected void handleFocusGained(Component comp) {
        if (this.editable) {
            this.setCustomEditorButtonVisible(true);
        }
    }

    protected void handleFocusLost(Component comp) {
        this.setCustomEditorButtonVisible(false);
        this.applyPropertyValue();
        if (!this.customEditorDialogOpen) {
            this.refresh();
        }
    }

    protected JButton createCustomEditorButton() {
        JButton b = new JButton();
        b.setText("");
        b.setBorderPainted(true);
        b.setContentAreaFilled(true);
        b.setFocusable(false);
        b.setOpaque(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/genericvariable_obj.gif")));
        b.setPreferredSize(new Dimension(this.customEditorButtonWidth, this.customEditorButtonHeight));
        b.setMaximumSize(b.getPreferredSize());
        b.setMinimumSize(b.getPreferredSize());
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyField.this.openCustomEditor();
            }
        });
        return b;
    }

    public JButton getCustomEditorButton() {
        if (this.customEditorButton == null) {
            this.setCustomEditorButton(this.createCustomEditorButton());
        }
        return this.customEditorButton;
    }

    protected void setCustomEditorButton(JButton customEditorButton) {
        this.customEditorButton = customEditorButton;
    }

    public boolean isCustomEditorButtonVisible() {
        return this.customEditorButtonVisible;
    }

    protected synchronized void setCustomEditorButtonVisible(boolean customEditorButtonVisible) {
        if (this.customEditorButtonVisible == customEditorButtonVisible) {
            return;
        }
        this.customEditorButtonVisible = customEditorButtonVisible;
        JButton button = this.getCustomEditorButton();
        if (customEditorButtonVisible) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.add((Component)button, gbc);
        } else {
            this.remove(button);
        }
        this.validate();
        this.repaint();
    }

    protected Component createCustomEditor() {
        if (this.propertyEditor != null) {
            return this.propertyEditor.getCustomEditor();
        }
        return null;
    }

    protected Component getEditorComponent() {
        return this.editorComponent;
    }

    protected synchronized void setEditorComponent(Component newEditorComponent) {
        if (this.editorComponent == newEditorComponent) {
            return;
        }
        if (this.editorComponent != null) {
            this.editorComponent.removeFocusListener(this.focusHandler);
            this.editorComponent.removeKeyListener(this.keyHandler);
            this.remove(this.editorComponent);
        }
        this.editorComponent = newEditorComponent;
        if (this.editorComponent != null) {
            this.editorComponent.addFocusListener(this.focusHandler);
            this.editorComponent.addKeyListener(this.keyHandler);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add(this.editorComponent, gbc);
            DropTarget dropTarget = new DropTarget(this.editorComponent, this.dropTargetHandler);
            this.editorComponent.setDropTarget(dropTarget);
            this.initDragSource(this.editorComponent);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        if (l != null) {
            this.keyListeners.add(l);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        if (l != null) {
            this.keyListeners.remove(l);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openCustomEditor() {
        try {
            this.customEditorDialogOpen = true;
            final JDialog dialog = new JDialog();
            JPanel contentPane = new JPanel();
            contentPane.setOpaque(true);
            contentPane.setLayout(new GridLayout(1, 1));
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.setOpaque(false);
            Component custom = this.createCustomEditor();
            if (custom != null) {
                String title = "Custom";
                Icon icon = null;
                String tip = "Custom editor";
                JPanel panel = new JPanel();
                panel.setOpaque(true);
                panel.setLayout(new GridLayout(1, 1));
                panel.add(custom);
                tabbedPane.addTab(title, icon, panel, tip);
            }
            if (this.beansToolkit != null && this.property != null && this.propertyEditor != null) {
                Class<?> propType;
                final NewObjectPanel newObjectPanel = new NewObjectPanel();
                ClassRegistry classReg = this.beansToolkit.getClassRegistry();
                newObjectPanel.setClassRegistry(classReg);
                ClassChooser.MultiClassFilter classFilter = null;
                int emptySearchAction = ClassChooser.EMPTY_DO_NOTHING;
                PropertyDescriptor descr = this.property.getDescriptor();
                if (descr != null && (propType = descr.getPropertyType()) != null) {
                    classFilter = new ClassChooser.MultiClassFilter(new Filter[]{new ClassChooser.PublicConstructorClassFilter(), new ClassChooser.AssignableFromClassFilter(classReg, propType.getName())});
                    if (propType != Object.class) {
                        emptySearchAction = ClassChooser.EMPTY_SEARCH_ALL;
                    }
                }
                newObjectPanel.setClassFilter(classFilter);
                newObjectPanel.setEmptySearchAction(emptySearchAction);
                newObjectPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        try {
                            Constructor constr = newObjectPanel.getSelectedConstructor();
                            if (constr == null) {
                                return;
                            }
                            Object[] params = newObjectPanel.getParameterValues();
                            Object newObj = constr.newInstance(params);
                            PropertyField.this.propertyEditor.setValue(newObj);
                            dialog.dispose();
                        }
                        catch (Exception e) {
                            PropertyField.this.handleException(e);
                        }
                    }
                });
                newObjectPanel.setPreferredSize(new Dimension(300, 200));
                String title = "Create";
                Icon icon = null;
                String tip = "Create new object";
                tabbedPane.addTab(title, icon, newObjectPanel, tip);
            }
            contentPane.add(tabbedPane);
            dialog.setTitle("Property Editor");
            dialog.setContentPane(contentPane);
            dialog.pack();
            int x = 0;
            int y = 0;
            Window win = SwingUtilities.windowForComponent(this);
            if (win != null) {
                Point p = new Point(0, 0);
                Dimension pref = dialog.getSize();
                if (pref != null) {
                    p.x = this.getWidth() - pref.width;
                    p.y = this.getHeight();
                }
                SwingUtilities.convertPointToScreen(p, this);
                x = p.x;
                y = p.y;
            }
            dialog.setLocation(x, y);
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    super.keyTyped(e);
                    char ch = e.getKeyChar();
                    switch (ch) {
                        case '\n': {
                            dialog.dispose();
                            return;
                        }
                        case '\u001b': {
                            dialog.dispose();
                            return;
                        }
                    }
                }
            };
            tabbedPane.addKeyListener(keyListener);
            dialog.addKeyListener(keyListener);
            Tools.ensureWindowFitsScreen((Window)dialog);
            dialog.setModal(true);
            dialog.setVisible(true);
            this.applyPropertyValue();
            this.refresh();
            if (this.editorComponent != null) {
                this.editorComponent.requestFocus();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.customEditorDialogOpen = false;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dim = super.getPreferredSize();
        if (dim.height < this.getMinimumSize().height) {
            dim.height = this.getMinimumSize().height;
        }
        if (this.customEditorButtonVisible) {
            return dim;
        }
        int w = dim.width + this.customEditorButtonWidth + 1;
        int h = Math.max(dim.height, this.customEditorButtonHeight);
        return new Dimension(w, h);
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor newPropertyEditor) {
        if (this.customPropertyEditor == newPropertyEditor) {
            return;
        }
        this.customPropertyEditor = newPropertyEditor;
        this.refresh();
    }

    protected void updateNonPaintableEditor(String newValueAsText) {
        boolean failed = true;
        try {
            if (this.propertyEditor != null) {
                this.propertyEditor.setAsText(newValueAsText);
            }
            failed = false;
        }
        catch (NullPointerException e) {
            failed = true;
        }
        catch (NumberFormatException e) {
            failed = true;
        }
        catch (Exception e) {
            failed = true;
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (failed) {
            this.editorComponent.setForeground(Color.red);
        } else {
            this.editorComponent.setForeground(this.getForeground());
        }
    }

    protected void applyPropertyValue() {
        if (!this.editable) {
            return;
        }
        if (this.property != null && this.propertyEditor != null) {
            try {
                Object newValue = this.propertyEditor.getValue();
                this.property.setValue(newValue);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public Object getValue() throws Exception {
        Property p = this.getProperty();
        return p == null ? null : p.getValue();
    }

    protected BeanContext getTargetBeanContext(int x, int y) {
        return this.dropBeanContext;
    }

    protected void drop(Object newValue) {
        try {
            if (this.property != null) {
                this.property.setValue(newValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.refresh();
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Property prop;
            if (PropertyField.this.dragSourceHandler == null) {
                return;
            }
            Object value = null;
            PropertyEditor editor = PropertyField.this.getPropertyEditor();
            if (editor != null) {
                try {
                    value = editor.getValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (value == null && (prop = PropertyField.this.getProperty()) != null) {
                try {
                    value = prop.getValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (value == null) {
                return;
            }
            ArrayList<Object> beans = new ArrayList<Object>();
            beans.add(value);
            PropertyField.this.dragSourceHandler.setBeanDropSupport(PropertyField.this.getBeanDropSupport());
            PropertyField.this.dragSourceHandler.startDrag(dge, beans);
        }
    }

    protected class DropBeanContext
    extends DefaultBeanContext {
        private static final long serialVersionUID = -2687119366134219913L;

        protected DropBeanContext() {
        }

        public boolean add(Object targetChild) {
            PropertyField.this.drop(targetChild);
            return true;
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            BeanDropSupport bds = PropertyField.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = PropertyField.this.getTargetBeanContext(pos.x, pos.y);
            this.dropBeans.clear();
            if (target != null) {
                bds.enumerateDropBeans(target, dtde, this.dropBeans);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            BeanDropSupport bds = PropertyField.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = PropertyField.this.getTargetBeanContext(pos.x, pos.y);
            if (target == null) {
                dtde.rejectDrag();
                return;
            }
            ArrayList temp = new ArrayList();
            boolean searchSuccess = bds.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                Class<?> propType;
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                Property prop = PropertyField.this.getProperty();
                PropertyDescriptor propDescr = prop == null ? null : prop.getDescriptor();
                Class<?> clazz = propType = propDescr == null ? null : propDescr.getPropertyType();
                if (propType != null && PropertyField.this.editable) {
                    for (Object o : this.dropBeans) {
                        Class<?> clazz2;
                        if (o == null || !propType.isAssignableFrom(clazz2 = o.getClass()) || !bds.acceptDropBean(target, o)) continue;
                        accepted = true;
                        break;
                    }
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            BeanDropSupport bds = PropertyField.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = dtde.getLocation();
            BeanContext target = PropertyField.this.getTargetBeanContext(pos.x, pos.y);
            Sys.println((String)(" - Drop target context: " + target));
            ArrayList temp = new ArrayList();
            boolean enumSuccess = bds.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    try {
                        Sys.println((String)" - Drop beans..");
                        bds.dropBeans(this.dropBeans, target, dropAction);
                        Sys.println((String)" - Drop completed.");
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        PropertyField.this.handleException(e);
                    }
                } else {
                    Sys.println((String)"DEBUG: drop target is null!");
                }
            }
            Sys.println((String)" - Drop failed!");
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyField.this.refresh();
        }
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object item = e.getItem();
            String text = item == null ? null : item.toString();
            PropertyField.this.updateNonPaintableEditor(text);
        }
    }

    protected class DocumentHandler
    extends DocumentAdapter {
        protected DocumentHandler() {
        }

        protected void handle(DocumentEvent e) {
            try {
                Document doc = e.getDocument();
                String text = doc.getText(0, doc.getLength());
                PropertyField.this.updateNonPaintableEditor(text);
            }
            catch (BadLocationException ex) {
                PropertyField.this.handleException(ex);
            }
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            char ch = e.getKeyChar();
            if (ch == '\n') {
                PropertyField.this.getCustomEditorButton().doClick();
            }
            if (!PropertyField.this.keyListeners.isEmpty()) {
                KeyEvent ke = this.makeKeyEvent(e);
                for (KeyListener kl : PropertyField.this.keyListeners) {
                    kl.keyTyped(ke);
                }
            }
        }

        protected KeyEvent makeKeyEvent(KeyEvent e) {
            KeyEvent ke = new KeyEvent(PropertyField.this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
            return ke;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (!PropertyField.this.keyListeners.isEmpty()) {
                KeyEvent ke = this.makeKeyEvent(e);
                for (KeyListener kl : PropertyField.this.keyListeners) {
                    kl.keyPressed(ke);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
            if (!PropertyField.this.keyListeners.isEmpty()) {
                KeyEvent ke = this.makeKeyEvent(e);
                for (KeyListener kl : PropertyField.this.keyListeners) {
                    kl.keyReleased(ke);
                }
                if (ke.isConsumed()) {
                    e.consume();
                }
            }
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            PropertyField.this.handleFocusGained(e.getComponent());
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            PropertyField.this.handleFocusLost(e.getComponent());
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            PropertyField.this.requestFocus();
        }
    }
}

