/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.components.BeanTree;
import com.spacekiller.util.beans.components.BeanTreeCellEditor;
import com.spacekiller.util.beans.components.BeanTreeCellRenderer;
import com.spacekiller.util.beans.customizers.AbstractCustomizer;
import com.spacekiller.util.beans.customizers.BeanSelectable;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import com.spacekiller.util.beans.model.BeanTreeModel;
import com.spacekiller.util.beans.model.BeanTreeNode;
import com.spacekiller.util.beans.model.DefaultBeanTreeModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BeanTreeCustomizer
extends AbstractCustomizer
implements BeanSelectable {
    private static final long serialVersionUID = 2751654418528958662L;
    private BeansToolkit beansToolkit;
    private BeanTree ivjBeanTree1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private boolean ivjConnPtoP1Aligning = false;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private TreeSelectionModel ivjselectionModel1 = null;
    private FeatureDescriptorFilter featureDescriptorFilter;
    private ListSelectionListener listSelectionListener;
    private BeanSelectionContext beanSelectionContext;
    private BeanContext beanContextOfBean;
    private DropTargetListener dropTargetHandler = new DropTargetHandler();
    private static final Logger logger = Logger.getLogger(BeanTreeCustomizer.class.getName());

    public BeanTreeCustomizer() {
        this.initialize();
    }

    private void beanTree1_MouseReleased(MouseEvent mouseEvent) {
        BeanSelectionContext ctx;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        TreePath path = this.getBeanTree1().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path != null && !this.getBeanTree1().isPathSelected(path)) {
            this.getBeanTree1().setSelectionPath(path);
        }
        if ((ctx = this.getBeanSelectionContext()) == null) {
            return;
        }
        JPopupMenu popup = ctx.getBeanSelectionJPopupMenu(this);
        if (popup == null) {
            return;
        }
        popup.show(this.getBeanTree1(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void connEtoC1(TreeSelectionEvent arg1) {
        try {
            this.selectionModel1_ValueChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(MouseEvent arg1) {
        try {
            this.beanTree1_MouseReleased(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.treeCustomizer_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetSource() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                if (this.getselectionModel1() != null) {
                    this.getBeanTree1().setSelectionModel(this.getselectionModel1());
                }
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                this.setselectionModel1(this.getBeanTree1().getSelectionModel());
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    protected BeanTreeModel createBeanTreeModel() {
        BeansToolkit btk = this.getBeansToolkit();
        FeatureDescriptorFilter filter = this.getFeatureDescriptorFilter();
        logger.fine("TreeCustomizer.createModel: " + btk + ", " + filter);
        return new DefaultBeanTreeModel(btk, filter);
    }

    protected TreeCellEditor createCellEditor(BeansToolkit btk) {
        return new BeanTreeCellEditor(btk, this.getBeanTree1());
    }

    protected TreeCellRenderer createCellRenderer(BeansToolkit btk) {
        return new BeanTreeCellRenderer(btk, this.getBeanTree1(), this.getBeanContextOfBean());
    }

    protected void finalize() throws Throwable {
        ToolTipManager.sharedInstance().unregisterComponent(this.getBeanTree1());
    }

    @Override
    public Object getBeanAt(int row) {
        TreePath path = this.getBeanTree1().getPathForRow(row);
        return this.getBeanAt(path);
    }

    public Object getBeanAt(TreePath path) {
        BeansToolkit btk = this.getBeansToolkit();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof BeanTreeNode) {
            BeanTreeNode beanNode = (BeanTreeNode)node;
            FeatureDescriptor feature = beanNode.getFeatureDescriptor();
            Object bean = beanNode.getBean();
            if (feature != null && bean != null) {
                if (feature instanceof BeanDescriptor) {
                    return bean;
                }
                if (feature instanceof PropertyDescriptor) {
                    try {
                        return btk.getValue((PropertyDescriptor)feature, bean);
                    }
                    catch (Exception e) {
                        this.handleCustomizerException(e);
                    }
                }
            }
        }
        return null;
    }

    public BeanContext getBeanContextOfBean() {
        return this.beanContextOfBean;
    }

    @Override
    public int getBeanCount() {
        return this.getBeanTreeModel().getBeanCount();
    }

    @Override
    public BeanSelectionContext getBeanSelectionContext() {
        return this.beanSelectionContext;
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            return super.getBeansToolkit();
        }
        return this.beansToolkit;
    }

    private BeanTree getBeanTree1() {
        if (this.ivjBeanTree1 == null) {
            try {
                this.ivjBeanTree1 = new BeanTree();
                this.ivjBeanTree1.setName("BeanTree1");
                this.ivjBeanTree1.setOpaque(false);
                this.ivjBeanTree1.setBounds(0, 0, 78, 72);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBeanTree1;
    }

    protected BeanTreeModel getBeanTreeModel() {
        return this.createBeanTreeModel();
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return this.featureDescriptorFilter;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getBeanTree1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    @Override
    public ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    @Override
    public void getSelectedBeans(Collection dst) {
        TreePath[] paths = this.getBeanTree1().getSelectionPaths();
        if (paths != null) {
            int count = paths.length;
            for (int c = 0; c < count; ++c) {
                dst.add(this.getBeanAt(paths[c]));
            }
        }
    }

    @Override
    public int[] getSelectedIndices() {
        return this.getBeanTree1().getSelectionRows();
    }

    private TreeSelectionModel getselectionModel1() {
        return this.ivjselectionModel1;
    }

    private void handleException(Throwable exception) {
        this.handleCustomizerException(exception);
    }

    private void initConnections() throws Exception {
        this.getBeanTree1().addPropertyChangeListener(this.ivjEventHandler);
        this.getBeanTree1().addMouseListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
    }

    private void initialize() {
        try {
            this.setName("TreeCustomizer");
            this.setLayout(new GridBagLayout());
            this.setSize(389, 280);
            GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
            constraintsJScrollPane1.gridx = 0;
            constraintsJScrollPane1.gridy = 0;
            constraintsJScrollPane1.fill = 1;
            constraintsJScrollPane1.weightx = 1.0;
            constraintsJScrollPane1.weighty = 1.0;
            this.add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
            this.initConnections();
            this.connEtoC3();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    public boolean isSelectedIndex(int row) {
        TreePath path = this.getBeanTree1().getPathForRow(row);
        return path == null ? false : this.getBeanTree1().isPathSelected(path);
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            BeanTreeCustomizer aBeanTreeCustomizer = new BeanTreeCustomizer();
            frame.setContentPane(aBeanTreeCustomizer);
            frame.setSize(aBeanTreeCustomizer.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.spacekiller.util.beans.customizers.AbstractCustomizer");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void selectionModel1_ValueChanged(TreeSelectionEvent treeSelectionEvent) {
        ListSelectionListener listener = this.getListSelectionListener();
        if (listener == null) {
            return;
        }
        int firstIndex = 0;
        int lastIndex = this.getBeanTreeModel().getBeanCount() - 1;
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, firstIndex, lastIndex, false);
        listener.valueChanged(listSelectionEvent);
    }

    public void setBeanContextOfBean(BeanContext newBeanContextOfBean) {
        this.beanContextOfBean = newBeanContextOfBean;
    }

    @Override
    public void setBeanSelectionContext(BeanSelectionContext newBeanSelectionContext) {
        this.beanSelectionContext = newBeanSelectionContext;
    }

    @Override
    public void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
        if (newBeansToolkit != null) {
            this.getBeanTree1().setCellRenderer(this.createCellRenderer(newBeansToolkit));
            this.getBeanTree1().setCellEditor(this.createCellEditor(newBeansToolkit));
        }
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter newFeatureDescriptorFilter) {
        this.featureDescriptorFilter = newFeatureDescriptorFilter;
    }

    @Override
    public void setListSelectionListener(ListSelectionListener newListSelectionListener) {
        this.listSelectionListener = newListSelectionListener;
    }

    @Override
    public void setObject(Object bean) {
        BeanTreeModel model = this.getBeanTreeModel();
        model.removeAllBeans();
        if (bean != null) {
            Iterator i = this.getBeans(bean);
            while (i.hasNext()) {
                Object o = i.next();
                if (o == null) continue;
                model.addBean(o);
            }
        }
        this.getBeanTree1().setModel(model);
    }

    private void setselectionModel1(TreeSelectionModel newValue) {
        if (this.ivjselectionModel1 != newValue) {
            try {
                if (this.ivjselectionModel1 != null) {
                    this.ivjselectionModel1.removeTreeSelectionListener(this.ivjEventHandler);
                }
                this.ivjselectionModel1 = newValue;
                if (this.ivjselectionModel1 != null) {
                    this.ivjselectionModel1.addTreeSelectionListener(this.ivjEventHandler);
                }
                this.connPtoP1SetSource();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    protected void treeCustomizer_Initialize() {
        this.setOpaque(false);
        this.getBeanTree1().setOpaque(false);
        this.getBeanTree1().setEditable(true);
        this.getBeanTree1().setInvokesStopCellEditing(true);
        this.getBeanTree1().setRootVisible(false);
        this.getBeanTree1().setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this.getBeanTree1());
        DropTarget dropTarget = new DropTarget(this, this.dropTargetHandler);
        this.setDropTarget(dropTarget);
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            Sys.println((String)("dragEnter: " + dtde));
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            Sys.println((String)("dragExit: " + dte));
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Sys.println((String)("dragOver: " + dtde));
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            Sys.println((String)("dropActionChanged: " + dtde));
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Sys.println((String)("drop: " + dtde));
        }
    }

    class IvjEventHandler
    implements MouseListener,
    PropertyChangeListener,
    TreeSelectionListener {
        IvjEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == BeanTreeCustomizer.this.getBeanTree1()) {
                BeanTreeCustomizer.this.connEtoC2(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == BeanTreeCustomizer.this.getBeanTree1() && evt.getPropertyName().equals("selectionModel")) {
                BeanTreeCustomizer.this.connPtoP1SetTarget();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getSource() == BeanTreeCustomizer.this.getselectionModel1()) {
                BeanTreeCustomizer.this.connEtoC1(e);
            }
        }
    }
}

