/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.beans.editors.AbstractPropertyFeatureEditor;
import com.spacekiller.util.beans.editors.ComplexPropertyEditor;
import com.spacekiller.util.beans.editors.DefaultComplexCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class ArrayPropertyEditor
extends AbstractPropertyFeatureEditor
implements ComplexPropertyEditor {
    public static Object addArrayElements(Class arrayElementType, Object oldArray, Object addArray) {
        int oldLength = ArrayPropertyEditor.getArrayLength(oldArray);
        return ArrayPropertyEditor.insertArrayElements(arrayElementType, oldArray, oldLength, addArray);
    }

    @Override
    public synchronized void addElement(Object element) {
        this.insertElementAt(element, this.getElementCount());
    }

    public static Object createArray(Class arrayElementType, int length) {
        return Array.newInstance(arrayElementType, length);
    }

    @Override
    public Object createElement() throws Exception {
        return this.createElement(this.getArrayElementType());
    }

    protected Class getArrayElementType() {
        PropertyDescriptor property;
        Class<?> propertyType;
        FeatureDescriptor feature = this.getFeatureDescriptor();
        if (feature != null && feature instanceof PropertyDescriptor && (propertyType = (property = (PropertyDescriptor)feature).getPropertyType()).isArray()) {
            return ArrayPropertyEditor.getArrayElementType(propertyType);
        }
        return null;
    }

    public static Class getArrayElementType(Class arrayClass) {
        return arrayClass.getComponentType();
    }

    public static int getArrayIndexOf(Object array, Object element) {
        int len = ArrayPropertyEditor.getArrayLength(array);
        if (element == null) {
            for (int c = 0; c < len; ++c) {
                if (Array.get(array, c) != null) continue;
                return c;
            }
        } else {
            for (int c = 0; c < len; ++c) {
                if (!element.equals(Array.get(array, c))) continue;
                return c;
            }
        }
        return -1;
    }

    public static int getArrayLength(Object array) {
        return array == null ? 0 : Array.getLength(array);
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        Class elementType = this.getArrayElementType();
        if (elementType == null || value == null) {
            return String.valueOf(value);
        }
        int len = Array.getLength(value);
        return "" + len + " elements [" + elementType.getName() + "]";
    }

    @Override
    public Component getCustomEditor() {
        DefaultComplexCustomEditor custom = new DefaultComplexCustomEditor();
        custom.setPropertyEditor(this);
        return custom;
    }

    @Override
    public Object getElementAt(int i) {
        return Array.get(this.getValue(), i);
    }

    @Override
    public int getElementCount() {
        return ArrayPropertyEditor.getArrayLength(this.getValue());
    }

    @Override
    public Iterator getElements() {
        final int len = this.getElementCount();
        return new Iterator(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < len;
            }

            public Object next() {
                return ArrayPropertyEditor.this.getElementAt(this.i++);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void getElements(Collection dst) {
        Object array = this.getValue();
        int count = this.getElementCount();
        for (int c = 0; c < count; ++c) {
            dst.add(Array.get(array, c));
        }
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        Class elementType = this.getArrayElementType();
        if (elementType == null || value == null) {
            return "null";
        }
        return "new " + elementType.getName() + "[] {<not currently supported>}";
    }

    public static Object insertArrayElements(Class arrayElementType, Object oldArray, int insertIndex, Object insertArray) {
        int oldLength = ArrayPropertyEditor.getArrayLength(oldArray);
        if (insertIndex < 0 || insertIndex > oldLength) {
            throw new IndexOutOfBoundsException("" + insertIndex);
        }
        int insertCount = ArrayPropertyEditor.getArrayLength(insertArray);
        if (insertCount < 1) {
            return oldArray;
        }
        int newLength = oldLength + insertCount;
        Object newArray = ArrayPropertyEditor.createArray(arrayElementType, newLength);
        if (insertIndex > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, insertIndex);
        }
        System.arraycopy(insertArray, 0, newArray, insertIndex, insertCount);
        int after = oldLength - insertIndex;
        if (after > 0) {
            System.arraycopy(oldArray, insertIndex, newArray, insertIndex + insertCount, after);
        }
        return newArray;
    }

    @Override
    public synchronized void insertElementAt(Object element, int index) {
        Object oldArray = this.getValue();
        Class elementType = this.getArrayElementType();
        Object insArray = ArrayPropertyEditor.createArray(elementType, 1);
        Array.set(insArray, 0, element);
        Object newArray = ArrayPropertyEditor.insertArrayElements(elementType, oldArray, index, insArray);
        this.setValue(newArray);
    }

    public static Object removeArrayElements(Class arrayElementType, Object oldArray, int[] removeIndices) {
        if (oldArray == null) {
            return null;
        }
        int oldLength = Array.getLength(oldArray);
        int newLength = oldLength - removeIndices.length;
        Object newArray = ArrayPropertyEditor.createArray(arrayElementType, newLength);
        int oldOfs = 0;
        int newOfs = 0;
        int count = removeIndices.length + 1;
        for (int c = 0; c < count; ++c) {
            int len;
            int n = len = c < removeIndices.length ? removeIndices[c] - oldOfs : oldLength - oldOfs;
            if (len < 0) continue;
            if (len > 0) {
                System.arraycopy(oldArray, oldOfs, newArray, newOfs, len);
            }
            oldOfs += len + 1;
            newOfs += len;
        }
        return newArray;
    }

    @Override
    public synchronized void removeElement(Object element) {
        int index = ArrayPropertyEditor.getArrayIndexOf(this.getValue(), element);
        if (index >= 0) {
            this.removeElementAt(index);
        }
    }

    @Override
    public synchronized void removeElementAt(int i) {
        Object oldArray = this.getValue();
        if (oldArray == null) {
            return;
        }
        Class elementType = this.getArrayElementType();
        Object newArray = ArrayPropertyEditor.removeArrayElements(elementType, oldArray, new int[]{i});
        this.setValue(newArray);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        throw new IllegalArgumentException("Cannot instantiate array from text: " + text);
    }

    @Override
    public void setElementAt(Object element, int i) {
        Array.set(this.getValue(), i, element);
    }

    @Override
    public boolean supportsAddElement() {
        return true;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public boolean supportsGetElementAt() {
        return true;
    }

    @Override
    public boolean supportsInsertElementAt() {
        return true;
    }

    @Override
    public boolean supportsRemoveElement() {
        return true;
    }

    @Override
    public boolean supportsRemoveElementAt() {
        return true;
    }

    @Override
    public boolean supportsSetElementAt() {
        return true;
    }
}

