/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.beans.editors.ColorPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorCustomEditor
extends JPanel {
    private static final long serialVersionUID = -5681905198672699819L;
    private Paint paint;
    private ColorPropertyEditor editor;
    private boolean refreshing;
    private JPanel jPanelColor = null;
    private JColorChooser jColorChooser = null;
    private JPanel jPanelAlpha = null;
    private JLabel jLabel = null;
    private JSlider jSliderAlpha = null;

    public ColorCustomEditor() {
        this.initialize();
        this.initPaintCustomEditor();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.weighty = 1.0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(526, 396));
        this.add((Component)this.getJPanelColor(), gridBagConstraints21);
    }

    private JPanel getJPanelColor() {
        if (this.jPanelColor == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            this.jPanelColor = new JPanel();
            this.jPanelColor.setLayout(new GridBagLayout());
            this.jPanelColor.add((Component)this.getJColorChooser(), gridBagConstraints1);
            this.jPanelColor.add((Component)this.getJPanelAlpha(), gridBagConstraints2);
        }
        return this.jPanelColor;
    }

    private JColorChooser getJColorChooser() {
        if (this.jColorChooser == null) {
            this.jColorChooser = new JColorChooser();
            this.jColorChooser.setOpaque(false);
        }
        return this.jColorChooser;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public synchronized void setPaint(Paint paint) {
        this.paint = paint;
        if (!this.refreshing) {
            this.refresh();
        }
        if (this.editor != null) {
            this.editor.setValue(paint);
        }
    }

    protected void initPaintCustomEditor() {
        this.getJColorChooser().getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ColorCustomEditor.this.refreshing) {
                    ColorCustomEditor.this.apply();
                }
            }
        });
        this.getJSliderAlpha().setMinimum(0);
        this.getJSliderAlpha().setMaximum(255);
        this.getJSliderAlpha().setValue(255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            Paint paint = this.paint;
            Color color = null;
            if (paint != null && paint instanceof Color) {
                color = (Color)paint;
            }
            this.getJColorChooser().setColor(color);
            if (color != null) {
                int alpha = color.getAlpha();
                this.getJSliderAlpha().setValue(alpha);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public ColorPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(ColorPropertyEditor editor) {
        this.editor = editor;
    }

    private JPanel getJPanelAlpha() {
        if (this.jPanelAlpha == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Alpha:");
            this.jLabel.setToolTipText("Transparency");
            this.jPanelAlpha = new JPanel();
            this.jPanelAlpha.setLayout(new GridBagLayout());
            this.jPanelAlpha.setOpaque(false);
            this.jPanelAlpha.add((Component)this.jLabel, gridBagConstraints3);
            this.jPanelAlpha.add((Component)this.getJSliderAlpha(), gridBagConstraints4);
        }
        return this.jPanelAlpha;
    }

    private JSlider getJSliderAlpha() {
        if (this.jSliderAlpha == null) {
            this.jSliderAlpha = new JSlider();
            this.jSliderAlpha.setOrientation(1);
            this.jSliderAlpha.setOpaque(false);
            this.jSliderAlpha.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!ColorCustomEditor.this.refreshing) {
                        ColorCustomEditor.this.apply();
                    }
                }
            });
        }
        return this.jSliderAlpha;
    }

    protected void apply() {
        Color color = this.getJColorChooser().getColor();
        int alpha = this.getJSliderAlpha().getValue();
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        if (color.getAlpha() != alpha) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        this.setPaint(color);
    }
}

