/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.Data;
import com.spacekiller.util.beans.editors.FilePropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FileCustomEditor
extends JPanel {
    private static final long serialVersionUID = -3723800563813965086L;
    public static String defaultDirectory = "";
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JFileChooser ivjJFileChooser1 = null;
    private boolean fieldSaveMode = false;
    private FilePropertyEditor fieldPropertyEditor = null;
    private static final Logger logger = Logger.getLogger(FileCustomEditor.class.getName());

    public FileCustomEditor() {
        this.initialize();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.jFileChooser1_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.fileCustomEditor_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(PropertyChangeEvent arg1) {
        try {
            this.fileCustomEditor_SaveMode(this.getSaveMode());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void disposeDialog() {
        for (Container comp = this; comp != null; comp = comp.getParent()) {
            if (comp instanceof Dialog) {
                ((Dialog)comp).dispose();
                return;
            }
            if (!(comp instanceof JDialog)) continue;
            ((JDialog)comp).dispose();
            return;
        }
    }

    private void fileCustomEditor_Initialize() {
        this.getJFileChooser1().setMultiSelectionEnabled(false);
        this.getJFileChooser1().setCurrentDirectory(new File(defaultDirectory));
    }

    private void fileCustomEditor_SaveMode(boolean arg1) {
        int type = 0;
        type = arg1 ? 1 : 0;
        this.getJFileChooser1().setDialogType(type);
    }

    private JFileChooser getJFileChooser1() {
        if (this.ivjJFileChooser1 == null) {
            try {
                this.ivjJFileChooser1 = new JFileChooser();
                this.ivjJFileChooser1.setName("JFileChooser1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFileChooser1;
    }

    public FilePropertyEditor getPropertyEditor() {
        return this.fieldPropertyEditor;
    }

    public boolean getSaveMode() {
        return this.fieldSaveMode;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getJFileChooser1().addActionListener(this.ivjEventHandler);
        this.addPropertyChangeListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("FileCustomEditor");
            this.setLayout(new GridLayout());
            this.setSize(505, 327);
            this.add((Component)this.getJFileChooser1(), this.getJFileChooser1().getName());
            this.initConnections();
            this.connEtoC2();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void jFileChooser1_ActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ApproveSelection")) {
            this.getPropertyEditor().setValue(this.getJFileChooser1().getSelectedFile());
            defaultDirectory = this.getJFileChooser1().getCurrentDirectory().getPath();
            this.disposeDialog();
        }
        if (e.getActionCommand().equals("CancelSelection")) {
            this.disposeDialog();
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            FileCustomEditor aFileCustomEditor = new FileCustomEditor();
            frame.setContentPane(aFileCustomEditor);
            frame.setSize(aFileCustomEditor.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setPropertyEditor(FilePropertyEditor propertyEditor) {
        this.fieldPropertyEditor = propertyEditor;
    }

    public void setSaveMode(boolean saveMode) {
        boolean oldValue = this.fieldSaveMode;
        this.fieldSaveMode = saveMode;
        this.firePropertyChange("saveMode", Data.toBoolean((boolean)oldValue), Data.toBoolean((boolean)saveMode));
    }

    class IvjEventHandler
    implements ActionListener,
    PropertyChangeListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FileCustomEditor.this.getJFileChooser1()) {
                FileCustomEditor.this.connEtoC1(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == FileCustomEditor.this && evt.getPropertyName().equals("saveMode")) {
                FileCustomEditor.this.connEtoC3(evt);
            }
        }
    }
}

