/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import javax.swing.JComponent;

public abstract class ImagePropertyEditor
extends JComponent
implements PropertyEditor {
    private static final long serialVersionUID = -9075377444612976362L;
    private static final Component imageObserver = new Panel();

    @Override
    public String getAsText() {
        return this.getPeerPropertyEditor().getAsText();
    }

    @Override
    public Component getCustomEditor() {
        return this.getPeerPropertyEditor().getCustomEditor();
    }

    protected abstract Image getImage();

    @Override
    public String getJavaInitializationString() {
        return this.getPeerPropertyEditor().getJavaInitializationString();
    }

    protected abstract PropertyEditor getPeerPropertyEditor();

    @Override
    public Dimension getPreferredSize() {
        Image img = this.getImage();
        if (img == null) {
            return new Dimension(16, 16);
        }
        return new Dimension(img.getWidth(imageObserver), img.getHeight(imageObserver));
    }

    @Override
    public String[] getTags() {
        return this.getPeerPropertyEditor().getTags();
    }

    @Override
    public Object getValue() {
        return this.getPeerPropertyEditor().getValue();
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle box = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.paintValue(g, box);
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        Image img = this.getImage();
        if (img != null) {
            gfx.drawImage(img, box.x, box.y, box.width, box.height, imageObserver);
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.getPeerPropertyEditor().setAsText(text);
    }

    @Override
    public void setValue(Object value) {
        this.getPeerPropertyEditor().setValue(value);
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.getPeerPropertyEditor().supportsCustomEditor();
    }
}

