/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.beans.editors.PaintPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaintCustomEditor
extends JPanel {
    private static final long serialVersionUID = 6296858767324511666L;
    private Paint paint;
    private PaintPropertyEditor editor;
    private boolean refreshing;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelColor = null;
    private JColorChooser jColorChooser = null;
    private JPanel jPanelGradient = null;
    private JPanel jPanelTexture = null;
    private JPanel jPanelAlpha = null;
    private JLabel jLabel = null;
    private JSlider jSliderAlpha = null;

    public PaintCustomEditor() {
        this.initialize();
        this.initPaintCustomEditor();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(526, 396));
        this.add((Component)this.getJTabbedPane(), gridBagConstraints);
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Color", new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/color_icon.gif")), this.getJPanelColor(), null);
            this.jTabbedPane.addTab("Gradient", new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/gradient_icon16.jpg")), this.getJPanelGradient(), null);
            this.jTabbedPane.addTab("Texture", new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/texture_icon16.jpg")), this.getJPanelTexture(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelColor() {
        if (this.jPanelColor == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            this.jPanelColor = new JPanel();
            this.jPanelColor.setLayout(new GridBagLayout());
            this.jPanelColor.add((Component)this.getJColorChooser(), gridBagConstraints1);
            this.jPanelColor.add((Component)this.getJPanelAlpha(), gridBagConstraints2);
        }
        return this.jPanelColor;
    }

    private JColorChooser getJColorChooser() {
        if (this.jColorChooser == null) {
            this.jColorChooser = new JColorChooser();
            this.jColorChooser.setOpaque(false);
        }
        return this.jColorChooser;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public synchronized void setPaint(Paint paint) {
        this.paint = paint;
        if (!this.refreshing) {
            this.refresh();
        }
        if (this.editor != null) {
            this.editor.setValue(paint);
        }
    }

    protected void initPaintCustomEditor() {
        this.getJColorChooser().getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!PaintCustomEditor.this.refreshing) {
                    PaintCustomEditor.this.apply();
                }
            }
        });
        this.getJSliderAlpha().setMinimum(0);
        this.getJSliderAlpha().setMaximum(255);
        this.getJSliderAlpha().setValue(255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            Paint paint = this.paint;
            Color color = null;
            if (paint != null && paint instanceof Color) {
                color = (Color)paint;
            }
            this.getJColorChooser().setColor(color);
            if (color != null) {
                int alpha = color.getAlpha();
                this.getJSliderAlpha().setValue(alpha);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public PaintPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(PaintPropertyEditor editor) {
        this.editor = editor;
    }

    private JPanel getJPanelGradient() {
        if (this.jPanelGradient == null) {
            this.jPanelGradient = new JPanel();
            this.jPanelGradient.setLayout(new GridBagLayout());
        }
        return this.jPanelGradient;
    }

    private JPanel getJPanelTexture() {
        if (this.jPanelTexture == null) {
            this.jPanelTexture = new JPanel();
            this.jPanelTexture.setLayout(new GridBagLayout());
        }
        return this.jPanelTexture;
    }

    private JPanel getJPanelAlpha() {
        if (this.jPanelAlpha == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Alpha:");
            this.jLabel.setToolTipText("Transparency");
            this.jPanelAlpha = new JPanel();
            this.jPanelAlpha.setLayout(new GridBagLayout());
            this.jPanelAlpha.setOpaque(false);
            this.jPanelAlpha.add((Component)this.jLabel, gridBagConstraints3);
            this.jPanelAlpha.add((Component)this.getJSliderAlpha(), gridBagConstraints4);
        }
        return this.jPanelAlpha;
    }

    private JSlider getJSliderAlpha() {
        if (this.jSliderAlpha == null) {
            this.jSliderAlpha = new JSlider();
            this.jSliderAlpha.setOrientation(1);
            this.jSliderAlpha.setOpaque(false);
            this.jSliderAlpha.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!PaintCustomEditor.this.refreshing) {
                        PaintCustomEditor.this.apply();
                    }
                }
            });
        }
        return this.jSliderAlpha;
    }

    protected void apply() {
        Color color = this.getJColorChooser().getColor();
        int alpha = this.getJSliderAlpha().getValue();
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        if (color.getAlpha() != alpha) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        this.setPaint(color);
    }
}

